package com.boyonk.bundlepins.client;

import com.boyonk.bundlepins.BundlePin;
import com.boyonk.bundlepins.BundlePins;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10437;
import net.minecraft.class_10439;
import net.minecraft.class_10458;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10809;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_1086;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_6880;
import net.minecraft.class_801;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_9826;
import net.minecraft.client.render.model.*;
import org.joml.Vector3f;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BundlePinsClient implements ClientModInitializer {

	public static final class_2960 BUNDLE_PROGRESS_BAR_FILL_TEXTURE = class_2960.method_60655(BundlePins.NAMESPACE, "container/bundle/bundle_progressbar_fill");
	public static final class_2960 BUNDLE_PROGRESS_BAR_FULL_TEXTURE = class_2960.method_60655(BundlePins.NAMESPACE, "container/bundle/bundle_progressbar_full");

	private static final class_809 TRANSFORMATION = new class_809(
			new class_804(new Vector3f(0f, 0f, 0f), new Vector3f(0f, 3f, 1f).mul(0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)),
			new class_804(new Vector3f(0f, 0f, 0f), new Vector3f(0f, 3f, 1f).mul(0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)),
			new class_804(new Vector3f(0f, -90f, 25f), new Vector3f(1.13f, 3.2f, 1.13f).mul(0.0625f), new Vector3f(0.68f, 0.68f, 0.68f)),
			new class_804(new Vector3f(0f, -90f, 25f), new Vector3f(1.13f, 3.2f, 1.13f).mul(0.0625f), new Vector3f(0.68f, 0.68f, 0.68f)),
			new class_804(new Vector3f(0f, 180f, 0f), new Vector3f(0f, 13f, 7f).mul(0.0625f), new Vector3f(1f, 1f, 1f)),
			new class_804(new Vector3f(0f, 0f, 0f), new Vector3f(0f, 0f, 16f).mul(0.0625f), new Vector3f(1f, 1f, 1f)),
			new class_804(new Vector3f(0f, 0f, 0f), new Vector3f(0f, 2f, 0f).mul(0.0625f), new Vector3f(0.5f, 0.5f, 0.5f)),
			new class_804(new Vector3f(0f, 180f, 0f), new Vector3f(0f, 0f, 0f).mul(0.0625f), new Vector3f(1f, 1f, 1f)),
			new class_804(new Vector3f(0f, 180f, 0f), new Vector3f(0f, 0f, 0f).mul(0.0625f), new Vector3f(1f, 1f, 1f))
	);


	private static final Map<class_6880<BundlePin>, class_10439> MODEL_CACHE = new HashMap<>();

	@Override
	public void onInitializeClient() {
		ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
			@Override
			public void method_14491(class_3300 manager) {
				synchronized (MODEL_CACHE) {
					MODEL_CACHE.clear();
				}
			}

			@Override
			public class_2960 getFabricId() {
				return class_2960.method_60655(BundlePins.NAMESPACE, "model_cache_clearer");
			}

		});

	}

	public static class_10439 getModel(class_6880<BundlePin> bundlePin) {
		synchronized (MODEL_CACHE) {
			if (MODEL_CACHE.containsKey(bundlePin)) return MODEL_CACHE.get(bundlePin);
		}

		class_9826 spriteGetter = new class_9826() {
			@Override
			public class_1058 method_65739(class_4730 id, class_10813 model) {
				return class_310.method_1551().method_72703().method_73030(id);
			}

			@Override
			public class_1058 method_65740(String name, class_10813 model) {
				return class_310.method_1551().method_72703().method_73025(class_1059.field_5275).method_4608(class_1047.method_4539());
			}
		};

		class_10817 closedModel = class_801.method_3479(new class_10419(Map.of("layer0", getTexture(bundlePin, false))), spriteGetter, class_1086.field_5350, null);
		class_10817 openModel = class_801.method_3479(new class_10419(Map.of("layer0", getTexture(bundlePin, true))), spriteGetter, class_1086.field_5350, null);

		class_10809 modelSettings = new class_10809(false, spriteGetter.method_65739(getTexture(bundlePin, false), null), TRANSFORMATION);

		class_10439 model = new class_10437(new class_10458(), new class_10430(List.of(), openModel.method_68048(), modelSettings), new class_10430(List.of(), closedModel.method_68048(), modelSettings));
		synchronized (MODEL_CACHE) {
			MODEL_CACHE.put(bundlePin, model);
		}
		return model;
	}

	static class_4730 getTexture(class_6880<BundlePin> bundlePin, boolean open) {
		return new class_4730(class_1059.field_5275, bundlePin.comp_349().assetId().method_45134(path -> "bundle_pins/" + path + (open ? "_open" : "")));
	}

}
