package com.boyonk.bundlepins.client.mixin;

import com.boyonk.bundlepins.BundlePin;
import com.boyonk.bundlepins.BundlePins;
import com.boyonk.bundlepins.client.BundlePinComponentHolder;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_5251;
import net.minecraft.class_5537;
import net.minecraft.class_5632;
import net.minecraft.class_6880;

@Mixin(class_5537.class)
public class BundleItemMixin {

	@ModifyReturnValue(method = "getItemBarColor", at = @At("RETURN"))
	int bundlepins$getItemBarColor(int original, @Local(argsOnly = true) class_1799 stack) {
		class_6880<BundlePin> bundlePin = stack.method_58694(BundlePins.DATA_COMPONENT_TYPE);
		if (bundlePin != null) {
			Optional<class_5251> color = bundlePin.comp_349().itemBarColor();
			if (color.isPresent()) {
				return color.get().method_27716();
			}
		}
		return original;
	}

	@ModifyReturnValue(method = "getTooltipData", at = @At("RETURN"))
	Optional<class_5632> bundlepins$getTooltipData(Optional<class_5632> original, @Local(argsOnly = true) class_1799 stack) {
		if (original.isEmpty()) return original;

		class_5632 data = original.get();

		class_6880<BundlePin> bundlePin = stack.method_58694(BundlePins.DATA_COMPONENT_TYPE);
		if (bundlePin == null) return original;

		if (data instanceof BundlePinComponentHolder) {
			((BundlePinComponentHolder) data).bundlePins$bundlePin(bundlePin);
		}
		return original;
	}

}
