package com.boyonk.bundlepins.data;

import com.boyonk.bundlepins.BundlePin;
import com.boyonk.bundlepins.BundlePins;
import com.boyonk.bundlepins.data.compat.AesCompatDataGenerator;
import com.boyonk.bundlepins.data.server.recipe.BundlePinRecipeGenerator;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_156;
import net.minecraft.class_2446;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_8790;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class BundlePinsDataGenerator implements DataGeneratorEntrypoint {

	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		FabricDataGenerator.Pack pack = generator.createPack();
		pack.addProvider(RegistryProvider::new);
		pack.addProvider(RecipeProvider::new);
		pack.addProvider(EnglishLanguageProvider::new);
		pack.addProvider(DutchLanguageProvider::new);

		AesCompatDataGenerator.initialize(generator.createBuiltinResourcePack(BundlePins.COMPAT_AES));
	}

	@Override
	public void buildRegistry(class_7877 registryBuilder) {
		registryBuilder.method_46777(BundlePins.REGISTRY, BundlePinsDataGenerator::bootstrap);
	}

	public static void bootstrap(class_7891<BundlePin> registerable) {
		AesCompatDataGenerator.bootstrap(registerable);
		register(registerable, BundlePins.QUARTZ, class_2583.field_24360.method_36139(0xFFE3D4C4));
		register(registerable, BundlePins.IRON, class_2583.field_24360.method_36139(0xFFECECEC));
		register(registerable, BundlePins.NETHERITE, class_2583.field_24360.method_36139(0xFF625859));
		register(registerable, BundlePins.COPPER, class_2583.field_24360.method_36139(0xFFB4684D));
		register(registerable, BundlePins.GOLD, class_2583.field_24360.method_36139(0xFFDEB12D));
		register(registerable, BundlePins.EMERALD, class_2583.field_24360.method_36139(0xFF11A036));
		register(registerable, BundlePins.DIAMOND, class_2583.field_24360.method_36139(0xFF6EECD2));
		register(registerable, BundlePins.LAPIS, class_2583.field_24360.method_36139(0xFF416E97));
		register(registerable, BundlePins.AMETHYST, class_2583.field_24360.method_36139(0xFF9A5CC6));
		register(registerable, BundlePins.RESIN, class_2583.field_24360.method_36139(0xFFFC7812));
	}

	public static void register(class_7891<BundlePin> registerable, class_5321<BundlePin> key, class_2583 style) {
		registerable.method_46838(key, new BundlePin(key.method_29177(), class_2561.method_43471(class_156.method_646("bundle_pin", key.method_29177())).method_10862(style), Optional.ofNullable(style.method_10973())));
	}

	public static void add(FabricLanguageProvider.TranslationBuilder builder, class_5321<BundlePin> key, String value) {
		builder.add(class_156.method_646("bundle_pin", key.method_29177()), value);
	}


	static class RegistryProvider extends FabricDynamicRegistryProvider {

		public RegistryProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected void configure(class_7225.class_7874 registries, Entries entries) {
			class_7225.class_7226<BundlePin> registry = registries.method_46762(BundlePins.REGISTRY);

			entries.add(registry, BundlePins.QUARTZ);
			entries.add(registry, BundlePins.IRON);
			entries.add(registry, BundlePins.NETHERITE);
			entries.add(registry, BundlePins.COPPER);
			entries.add(registry, BundlePins.GOLD);
			entries.add(registry, BundlePins.EMERALD);
			entries.add(registry, BundlePins.DIAMOND);
			entries.add(registry, BundlePins.LAPIS);
			entries.add(registry, BundlePins.AMETHYST);
			entries.add(registry, BundlePins.RESIN);
		}


		@Override
		public String method_10321() {
			return "Registry";
		}
	}

	private static class RecipeProvider extends FabricRecipeProvider {

		public RecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 exporter) {
			return new BundlePinRecipeGenerator(wrapperLookup, exporter) {
				@Override
				public void method_10419() {
					this.offerBundlePinRecipe(BundlePins.QUARTZ, ConventionalItemTags.QUARTZ_GEMS);
					this.offerBundlePinRecipe(BundlePins.IRON, ConventionalItemTags.IRON_INGOTS);
					this.offerBundlePinRecipe(BundlePins.NETHERITE, ConventionalItemTags.NETHERITE_INGOTS);
					this.offerBundlePinRecipe(BundlePins.COPPER, ConventionalItemTags.COPPER_INGOTS);
					this.offerBundlePinRecipe(BundlePins.GOLD, ConventionalItemTags.GOLD_INGOTS);
					this.offerBundlePinRecipe(BundlePins.EMERALD, ConventionalItemTags.EMERALD_GEMS);
					this.offerBundlePinRecipe(BundlePins.DIAMOND, ConventionalItemTags.DIAMOND_GEMS);
					this.offerBundlePinRecipe(BundlePins.LAPIS, ConventionalItemTags.LAPIS_GEMS);
					this.offerBundlePinRecipe(BundlePins.AMETHYST, ConventionalItemTags.AMETHYST_GEMS);
					this.offerBundlePinRecipe(BundlePins.RESIN, ConventionalItemTags.RESIN_BRICKS);
				}
			};
		}

		@Override
		public String method_10321() {
			return "Recipes";
		}
	}

	private static class EnglishLanguageProvider extends FabricLanguageProvider {
		protected EnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, "en_us", registryLookup);
		}

		@Override
		public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder builder) {
			add(builder, BundlePins.QUARTZ, "Quartz Pin");
			add(builder, BundlePins.IRON, "Iron Pin");
			add(builder, BundlePins.NETHERITE, "Netherite Pin");
			add(builder, BundlePins.COPPER, "Copper Pin");
			add(builder, BundlePins.GOLD, "Gold Pin");
			add(builder, BundlePins.EMERALD, "Emerald Pin");
			add(builder, BundlePins.DIAMOND, "Diamond Pin");
			add(builder, BundlePins.LAPIS, "Lapis Pin");
			add(builder, BundlePins.AMETHYST, "Amethyst Pin");
			add(builder, BundlePins.RESIN, "Resin Pin");
		}
	}

	private static class DutchLanguageProvider extends FabricLanguageProvider {
		protected DutchLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, "nl_nl", registryLookup);
		}

		@Override
		public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder builder) {
			add(builder, BundlePins.QUARTZ, "Kwartsspeld");
			add(builder, BundlePins.IRON, "IJzerspeld");
			add(builder, BundlePins.NETHERITE, "Netherietspeld");
			add(builder, BundlePins.COPPER, "Koperspeld");
			add(builder, BundlePins.GOLD, "Goudspeld");
			add(builder, BundlePins.EMERALD, "Smaragdspeld");
			add(builder, BundlePins.DIAMOND, "Diamantspeld");
			add(builder, BundlePins.LAPIS, "Lapislazulispeld");
			add(builder, BundlePins.AMETHYST, "Amethistspeld");
			add(builder, BundlePins.RESIN, "Harsspeld");
		}
	}

}
