package com.boyonk.bundlepins.data.compat;

import com.boyonk.bundlepins.BundlePin;
import com.boyonk.bundlepins.BundlePins;
import com.boyonk.bundlepins.data.BundlePinsDataGenerator;
import com.boyonk.bundlepins.data.server.recipe.BundlePinRecipeGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.impl.tag.convention.v2.TagRegistration;
import net.minecraft.class_2446;
import net.minecraft.class_2583;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7891;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class AesCompatDataGenerator {

	private static final class_5321<BundlePin> BRONZE = BundlePins.of("aes/bronze");
	private static final class_5321<BundlePin> TIN = BundlePins.of("aes/tin");


	public static void initialize(FabricDataGenerator.Pack pack) {
		pack.addProvider(RegistryProvider::new);
		pack.addProvider(RecipeProvider::new);
		pack.addProvider(EnglishLanguageProvider::new);
		pack.addProvider(DutchLanguageProvider::new);
	}

	public static void bootstrap(class_7891<BundlePin> registerable) {
		BundlePinsDataGenerator.register(registerable, BRONZE, class_2583.field_24360.method_36139(0x8B5918));
		BundlePinsDataGenerator.register(registerable, TIN, class_2583.field_24360.method_36139(0x687D95));
	}

	private static class RegistryProvider extends FabricDynamicRegistryProvider {

		public RegistryProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected void configure(class_7225.class_7874 registries, Entries entries) {
			class_7225.class_7226<BundlePin> registry = registries.method_46762(BundlePins.REGISTRY);

			entries.add(registry, BRONZE);
			entries.add(registry, TIN);
		}

		@Override
		public String method_10321() {
			return "Registry";
		}
	}

	private static class RecipeProvider extends FabricRecipeProvider {

		public RecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}

		@Override
		protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 exporter) {
			return new BundlePinRecipeGenerator(wrapperLookup, exporter) {
				@Override
				public void method_10419() {
					this.offerBundlePinRecipe(BRONZE, TagRegistration.ITEM_TAG.registerC("ingots/bronze"));
					this.offerBundlePinRecipe(TIN, TagRegistration.ITEM_TAG.registerC("ingots/tin"));
				}
			};
		}

		@Override
		public String method_10321() {
			return "Recipes";
		}
	}


	private static class EnglishLanguageProvider extends FabricLanguageProvider {
		protected EnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, "en_us", registryLookup);
		}

		@Override
		public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder builder) {
			BundlePinsDataGenerator.add(builder, BRONZE, "Bronze Pin");
			BundlePinsDataGenerator.add(builder, TIN, "Tin Pin");
		}
	}

	private static class DutchLanguageProvider extends FabricLanguageProvider {
		protected DutchLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, "nl_nl", registryLookup);
		}

		@Override
		public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder builder) {
			BundlePinsDataGenerator.add(builder, BRONZE, "Bronsspeld");
			BundlePinsDataGenerator.add(builder, TIN, "Tinspeld");
		}


	}
}
