package com.boyonk.bundlepins.data.server.recipe;

import com.boyonk.bundlepins.BundlePin;
import com.boyonk.bundlepins.recipe.BundlePinRecipe;
import org.jetbrains.annotations.Nullable;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2119;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6880;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.class_8790;

public class BundlePinRecipeJsonBuilder implements class_5797 {

	private final class_7800 category;
	private final class_6880<BundlePin> bundlePin;
	private final class_1856 input;
	private final class_1856 material;

	private final Map<String, class_175<?>> criteria = new LinkedHashMap<>();
	@Nullable
	private String group;

	private BundlePinRecipeJsonBuilder(class_7800 category, class_6880<BundlePin> bundlePin, class_1856 input, class_1856 material) {
		this.category = category;
		this.bundlePin = bundlePin;
		this.input = input;
		this.material = material;
	}

	public static BundlePinRecipeJsonBuilder create(class_7800 category, class_6880<BundlePin> bundlePin, class_1856 input, class_1856 material) {
		return new BundlePinRecipeJsonBuilder(category, bundlePin, input, material);
	}

	@Override
	public BundlePinRecipeJsonBuilder method_33530(String string, class_175<?> advancementCriterion) {
		this.criteria.put(string, advancementCriterion);
		return this;
	}

	@Override
	public BundlePinRecipeJsonBuilder method_33529(@Nullable String string) {
		this.group = string;
		return this;
	}

	@Override
	public class_1792 method_36441() {
		return class_1802.field_8162;
	}

	@Override
	public void method_10431(class_8790 exporter) {
		this.method_17972(exporter, class_5321.method_29179(class_7924.field_52178, this.bundlePin.method_40230().orElseThrow().method_29177().method_48331("_bundle_pin")));
	}

	@Override
	public void method_17972(class_8790 exporter, class_5321<class_1860<?>> recipeKey) {
		this.validate(recipeKey);
		class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeKey)).method_703(class_170.class_171.method_753(recipeKey)).method_704(class_8782.class_8797.field_1257);
		this.criteria.forEach(builder::method_705);
		BundlePinRecipe recipe = new BundlePinRecipe(Objects.requireNonNullElse(this.group, ""), class_5797.method_55308(this.category), this.bundlePin, this.input, this.material);
		exporter.method_53819(recipeKey, recipe, builder.method_695(recipeKey.method_29177().method_45138("recipes/" + this.category.method_46203() + "/")));
	}


	private void validate(class_5321<class_1860<?>> recipeKey) {
		if (this.criteria.isEmpty()) {
			throw new IllegalStateException("No way of obtaining recipe " + recipeKey.method_29177());
		}
	}

}
