/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.gui;

import codechicken.core.gui.GuiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiCCButton
extends GuiWidget {
    public String text;
    public String actionCommand;
    private boolean isEnabled = true;
    public boolean visible = true;

    public GuiCCButton(int x, int y, int width, int height, String text) {
        super(x, y, width, height);
        this.text = text;
    }

    public void setText(String s) {
        this.text = s;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.isEnabled && this.pointInside(x, y) && this.actionCommand != null) {
            this.sendAction(this.actionCommand, button);
            Minecraft.getMinecraft().getSoundHandler().playSound((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        if (!this.visible) {
            return;
        }
        this.drawButtonTex(mousex, mousey);
        if (this.text != null) {
            this.drawText(mousex, mousey);
        }
    }

    public void drawButtonTex(int mousex, int mousey) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderEngine.bindTexture(guiTex);
        int state = this.getButtonTex(mousex, mousey);
        this.drawTexturedModalRect(this.x, this.y, 0, 46 + state * 20, this.width / 2, this.height / 2);
        this.drawTexturedModalRect(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + state * 20, this.width / 2, this.height / 2);
        this.drawTexturedModalRect(this.x, this.y + this.height / 2, 0, 46 + state * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
        this.drawTexturedModalRect(this.x + this.width / 2, this.y + this.height / 2, 200 - this.width / 2, 46 + state * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
    }

    public int getButtonTex(int mousex, int mousey) {
        return !this.isEnabled ? 0 : (this.pointInside(mousex, mousey) ? 2 : 1);
    }

    public void drawText(int mousex, int mousey) {
        this.drawCenteredString(this.fontRenderer, this.text, this.x + this.width / 2, this.y + (this.height - 8) / 2, this.getTextColour(mousex, mousey));
    }

    public int getTextColour(int mousex, int mousey) {
        return !this.isEnabled ? -6250336 : (this.pointInside(mousex, mousey) ? -96 : -2039584);
    }

    public GuiCCButton setActionCommand(String string) {
        this.actionCommand = string;
        return this;
    }
}

