/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.gui.GuiWidget;
import codechicken.core.gui.IGuiActionListener;
import codechicken.lib.gui.GuiDraw;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerWidget
extends GuiContainer
implements IGuiActionListener {
    public ArrayList<GuiWidget> widgets = new ArrayList();

    public GuiContainerWidget(Container inventorySlots) {
        this(inventorySlots, 176, 166);
    }

    public GuiContainerWidget(Container inventorySlots, int xSize, int ySize) {
        super(inventorySlots);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void setWorldAndResolution(Minecraft mc, int i, int j) {
        super.setWorldAndResolution(mc, i, j);
        if (this.widgets.isEmpty()) {
            this.addWidgets();
        }
    }

    public void add(GuiWidget widget) {
        this.widgets.add(widget);
        widget.onAdded((GuiScreen)this);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mousex, int mousey) {
        GL11.glTranslated((double)this.guiLeft, (double)this.guiTop, (double)0.0);
        this.drawBackground();
        for (GuiWidget widget : this.widgets) {
            widget.draw(mousex - this.guiLeft, mousey - this.guiTop, f);
        }
        GL11.glTranslated((double)(-this.guiLeft), (double)(-this.guiTop), (double)0.0);
    }

    public void drawBackground() {
    }

    protected void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseClicked(x - this.guiLeft, y - this.guiTop, button);
        }
    }

    protected void mouseMovedOrUp(int x, int y, int button) {
        super.mouseMovedOrUp(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseMovedOrUp(x - this.guiLeft, y - this.guiTop, button);
        }
    }

    protected void mouseClickMove(int x, int y, int button, long time) {
        super.mouseClickMove(x, y, button, time);
        for (GuiWidget widget : this.widgets) {
            widget.mouseDragged(x - this.guiLeft, y - this.guiTop, button, time);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.mc.currentScreen == this) {
            for (GuiWidget widget : this.widgets) {
                widget.update();
            }
        }
    }

    public void keyTyped(char c, int keycode) {
        super.keyTyped(c, keycode);
        for (GuiWidget widget : this.widgets) {
            widget.keyTyped(c, keycode);
        }
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            Point p = GuiDraw.getMousePosition();
            int scroll = i > 0 ? 1 : -1;
            for (GuiWidget widget : this.widgets) {
                widget.mouseScrolled(p.x, p.y, scroll);
            }
        }
    }

    @Override
    public void actionPerformed(String ident, Object ... params) {
    }

    public void addWidgets() {
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        this.widgets.clear();
    }
}

