/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryNBT
implements IInventory {
    protected ItemStack[] items;
    protected NBTTagCompound tag;

    public InventoryNBT(int size, NBTTagCompound tag) {
        this.tag = tag;
        this.items = new ItemStack[size];
        this.readNBT();
    }

    private void writeNBT() {
        this.tag.setTag("items", (NBTBase)InventoryUtils.writeItemStacksToTag(this.items, this.getInventoryStackLimit()));
    }

    private void readNBT() {
        if (this.tag.hasKey("items")) {
            InventoryUtils.readItemStacksFromTag(this.items, this.tag.getTagList("items", 10));
        }
    }

    public int getSizeInventory() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return InventoryUtils.getStackInSlotOnClosing(this, slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.markDirty();
    }

    public String getInventoryName() {
        return "NBT";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        this.writeNBT();
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return true;
    }
}

