/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.ClientUtils;
import codechicken.core.ReflectionManager;
import codechicken.core.launch.CodeChickenCorePlugin;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiModListScroll {
    private static List<ModContainer> scrollMods = new LinkedList<ModContainer>();
    private static ModContainer lastMod;
    private static double scroll;
    private static double lastFrameTime;
    private static double timeStart;

    public static void register(Object mod) {
        GuiModListScroll.register(FMLCommonHandler.instance().findContainerFor(mod));
    }

    private static void register(ModContainer mod) {
        if (MinecraftForgeClient.getStencilBits() == 0) {
            CodeChickenCorePlugin.logger.error("Unable to do mod description scrolling due to lack of stencil buffer");
        } else {
            scrollMods.add(mod);
        }
    }

    private static void screenshotStencil(int x) {
        Dimension d = GuiDraw.displayRes();
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(d.width * d.height));
        BufferedImage img = new BufferedImage(d.width, d.height, 1);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glReadPixels((int)0, (int)0, (int)d.width, (int)d.height, (int)6401, (int)5121, (ByteBuffer)buf);
        for (int i = 0; i < d.width; ++i) {
            for (int j = 0; j < d.height; ++j) {
                img.setRGB(i, d.height - j - 1, buf.get(j * d.width + i) == 0 ? 0 : 0xFFFFFF);
            }
        }
        try {
            ImageIO.write((RenderedImage)img, "png", new File("stencil" + x + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void draw(GuiModList gui, int mouseX, int mouseY) {
        boolean needsScroll;
        ModContainer selectedMod = ReflectionManager.getField(GuiModList.class, ModContainer.class, (Object)gui, "selectedMod");
        if (selectedMod != lastMod) {
            lastMod = selectedMod;
            scroll = 0.0;
            timeStart = ClientUtils.getRenderTime();
        }
        if (!scrollMods.contains(selectedMod) || selectedMod.getMetadata().autogenerated) {
            return;
        }
        int y1 = GuiModListScroll.calcDescY(gui, selectedMod);
        int y1draw = y1 + 10;
        int y2 = gui.height - 38;
        int x2 = gui.width - 20;
        int x1 = ReflectionManager.getField(GuiModList.class, Integer.class, (Object)gui, "listWidth") + 20;
        if (x2 - x1 <= 20) {
            return;
        }
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilOp((int)0, (int)0, (int)0);
        GuiDraw.drawRect(0, 0, gui.width, gui.height, -1);
        GuiModListScroll.screenshotStencil(1);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GuiDraw.drawRect(x1, y1, gui.width - x1, gui.height - y1, -1);
        GL11.glStencilOp((int)0, (int)0, (int)0);
        GuiDraw.drawRect(gui.width / 2 - 75, y2, 200, 20, -1);
        GuiModListScroll.screenshotStencil(2);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        gui.drawDefaultBackground();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilOp((int)0, (int)0, (int)0);
        GuiDraw.drawRect(0, 0, gui.width, gui.height, -1);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GuiDraw.drawRect(x1, y1draw, x2 - x1, y2 - y1draw, -1);
        GuiModListScroll.screenshotStencil(3);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        String description = selectedMod.getMetadata().description;
        int height = GuiDraw.fontRenderer.listFormattedStringToWidth(description, x2 - x1).size() * GuiDraw.fontRenderer.FONT_HEIGHT;
        boolean bl = needsScroll = height > y2 - y1draw;
        if (ClientUtils.getRenderTime() - timeStart > 40.0 && needsScroll) {
            double dt = ClientUtils.getRenderTime() - lastFrameTime;
            if (new Rectangle4i(x1, y1draw, x2 - x1, y2 - y1draw).contains(mouseX, mouseY)) {
                double d = Keyboard.isKeyDown((int)200) ? -1.0 : (Keyboard.isKeyDown((int)208) ? 1.0 : 0.0);
                scroll += d * dt * 1.5;
            } else {
                scroll += dt * 0.2;
            }
        }
        lastFrameTime = ClientUtils.getRenderTime();
        double dy = scroll % (double)(height + 20);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(-dy), (double)0.0);
        GuiDraw.fontRenderer.drawSplitString(description, x1, y1draw, x2 - x1, 0xDDDDDD);
        if (needsScroll) {
            GL11.glTranslated((double)0.0, (double)(height + 20), (double)0.0);
            GuiDraw.fontRenderer.drawSplitString(description, x1, y1draw, x2 - x1, 0xDDDDDD);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2960);
    }

    private static int calcDescY(GuiModList gui, ModContainer mod) {
        ModMetadata meta = mod.getMetadata();
        int y = 35;
        if (meta.logoFile.isEmpty() && ReflectionManager.getField(GuiModList.class, ResourceLocation.class, (Object)gui, "cachedLogo") != null) {
            y += 65;
        }
        y += 12;
        y += 40;
        if (!meta.credits.isEmpty()) {
            y += 10;
        }
        if (!meta.childMods.isEmpty()) {
            y += 10;
        }
        return y;
    }
}

