/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.commands;

import codechicken.core.ServerUtils;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public abstract class CoreCommand
implements ICommand {
    public abstract boolean OPOnly();

    public String getCommandUsage(ICommandSender var1) {
        return "/" + this.getCommandName() + " help";
    }

    public void processCommand(ICommandSender listener, String[] args) {
        WCommandSender wsender = new WCommandSender(listener);
        if (args.length < this.minimumParameters() || args.length == 1 && args[0].equals("help")) {
            this.printHelp(wsender);
            return;
        }
        String command = this.getCommandName();
        for (String arg : args) {
            command = command + " " + arg;
        }
        this.handleCommand(command, wsender.getCommandSenderName(), args, wsender);
    }

    public abstract void handleCommand(String var1, String var2, String[] var3, WCommandSender var4);

    public abstract void printHelp(WCommandSender var1);

    public final EntityPlayerMP getPlayer(String name) {
        return ServerUtils.getPlayer(name);
    }

    public WorldServer getWorld(int dimension) {
        return DimensionManager.getWorld((int)dimension);
    }

    public WorldServer getWorld(EntityPlayer player) {
        return (WorldServer)player.worldObj;
    }

    public int compareTo(Object arg0) {
        return this.getCommandName().compareTo(((ICommand)arg0).getCommandName());
    }

    public List<String> getCommandAliases() {
        return null;
    }

    public List<String> addTabCompletionOptions(ICommandSender var1, String[] var2) {
        return null;
    }

    public boolean isUsernameIndex(String[] astring, int i) {
        return false;
    }

    public boolean canCommandSenderUseCommand(ICommandSender var1) {
        if (this.OPOnly()) {
            if (var1 instanceof EntityPlayer) {
                return MinecraftServer.getServer().getConfigurationManager().func_152596_g(((EntityPlayer)var1).getGameProfile());
            }
            return var1 instanceof MinecraftServer;
        }
        return true;
    }

    public abstract int minimumParameters();

    public class WCommandSender
    implements ICommandSender {
        public ICommandSender wrapped;

        public WCommandSender(ICommandSender sender) {
            this.wrapped = sender;
        }

        public String getCommandSenderName() {
            return this.wrapped.getCommandSenderName();
        }

        public void addChatMessage(IChatComponent string) {
            this.wrapped.addChatMessage(string);
        }

        public boolean canCommandSenderUseCommand(int i, String s) {
            return this.wrapped.canCommandSenderUseCommand(i, s);
        }

        public ChunkCoordinates getPlayerCoordinates() {
            return this.wrapped.getPlayerCoordinates();
        }

        public World getEntityWorld() {
            return this.wrapped.getEntityWorld();
        }

        public IChatComponent func_145748_c_() {
            return new ChatComponentText(this.getCommandSenderName());
        }

        public void chatT(String s, Object ... params) {
            this.addChatMessage((IChatComponent)new ChatComponentTranslation(s, params));
        }

        public void chatOpsT(String s, Object ... params) {
            for (EntityPlayerMP player : ServerUtils.getPlayers()) {
                if (!MinecraftServer.getServer().getConfigurationManager().func_152596_g(player.getGameProfile())) continue;
                player.addChatMessage((IChatComponent)new ChatComponentTranslation(s, params));
            }
        }
    }
}

