/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.ContainerExtended;
import codechicken.lib.inventory.IContainerSyncVar;
import codechicken.lib.packet.PacketCustom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public abstract class ContainerSynchronised
extends ContainerExtended {
    private ArrayList<IContainerSyncVar> syncVars = new ArrayList();

    public PacketCustom createSyncPacket() {
        return this.getPacket(2);
    }

    public final void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.syncVars.size(); ++i) {
            IContainerSyncVar var = this.syncVars.get(i);
            if (!var.changed()) continue;
            PacketCustom packet = this.createSyncPacket();
            packet.writeByte(i);
            var.writeChange(packet);
            this.sendContainerPacket(packet);
            var.reset();
        }
    }

    @Override
    public void sendContainerAndContentsToPlayer(Container container, List<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        super.sendContainerAndContentsToPlayer(container, list, playerCrafters);
        for (int i = 0; i < this.syncVars.size(); ++i) {
            IContainerSyncVar var = this.syncVars.get(i);
            PacketCustom packet = this.createSyncPacket();
            packet.writeByte(i);
            var.writeChange(packet);
            var.reset();
            for (EntityPlayerMP player : playerCrafters) {
                packet.sendToPlayer((EntityPlayer)player);
            }
        }
    }

    public void addSyncVar(IContainerSyncVar var) {
        this.syncVars.add(var);
    }

    @Override
    public final void handleClientPacket(PacketCustom packet) {
        this.syncVars.get(packet.readUByte()).readChange(packet);
    }

    public List<IContainerSyncVar> getSyncedVars() {
        return Collections.unmodifiableList(this.syncVars);
    }
}

