/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryCopy
implements IInventory {
    public boolean[] accessible;
    public ItemStack[] items;
    public IInventory inv;

    public InventoryCopy(IInventory inv) {
        this.items = new ItemStack[inv.getSizeInventory()];
        this.accessible = new boolean[inv.getSizeInventory()];
        this.inv = inv;
        this.update();
    }

    public void update() {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            if (stack == null) continue;
            this.items[i] = stack.copy();
        }
    }

    public InventoryCopy open(InventoryRange access) {
        int lslot = access.lastSlot();
        if (lslot > this.accessible.length) {
            boolean[] l_accessible = new boolean[lslot];
            ItemStack[] l_items = new ItemStack[lslot];
            System.arraycopy(this.accessible, 0, l_accessible, 0, this.accessible.length);
            System.arraycopy(this.items, 0, l_items, 0, this.items.length);
            this.accessible = l_accessible;
            this.items = l_items;
        }
        for (int slot : access.slots) {
            this.accessible[slot] = true;
        }
        return this;
    }

    public int getSizeInventory() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return InventoryUtils.getStackInSlotOnClosing(this, slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.markDirty();
    }

    public String getInventoryName() {
        return "copy";
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.inv.isItemValidForSlot(i, itemstack);
    }

    public boolean hasCustomInventoryName() {
        return true;
    }
}

