/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LC;
import codechicken.lib.lighting.LightMatrix;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderPipeline;
import codechicken.lib.render.Vertex5;
import codechicken.lib.util.Copyable;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class CCRenderState {
    public final CCRenderPipeline pipeline;
    private static final ThreadLocal<CCRenderState> instances = ThreadLocal.withInitial(CCRenderState::new);
    private static int nextOperationIndex;
    private static ArrayList<VertexAttribute<?>> vertexAttributes;
    public VertexAttribute<Vector3[]> normalAttrib = new VertexAttribute<Vector3[]>(){
        private Vector3[] normalRef;

        @Override
        public Vector3[] newArray(int length) {
            return new Vector3[length];
        }

        @Override
        public boolean load(CCRenderState state) {
            this.normalRef = state.model.getAttributes(this);
            if (state.model.hasAttribute(this)) {
                return this.normalRef != null;
            }
            if (state.model.hasAttribute(CCRenderState.this.sideAttrib)) {
                state.pipeline.addDependency(CCRenderState.this.sideAttrib);
                return true;
            }
            throw new IllegalStateException("Normals requested but neither normal or side attrutes are provided by the model");
        }

        @Override
        public void operate(CCRenderState state) {
            if (this.normalRef != null) {
                state.setNormalInstance(this.normalRef[state.vertexIndex]);
            } else {
                state.setNormalInstance(Rotation.axes[state.side]);
            }
        }
    };
    public VertexAttribute<int[]> colourAttrib = new VertexAttribute<int[]>(){
        private int[] colourRef;

        @Override
        public int[] newArray(int length) {
            return new int[length];
        }

        @Override
        public boolean load(CCRenderState state) {
            this.colourRef = state.model.getAttributes(this);
            return this.colourRef != null || !state.model.hasAttribute(this);
        }

        @Override
        public void operate(CCRenderState state) {
            if (this.colourRef != null) {
                state.setColourInstance(ColourRGBA.multiply(state.baseColour, this.colourRef[state.vertexIndex]));
            } else {
                state.setColourInstance(state.baseColour);
            }
        }
    };
    public VertexAttribute<int[]> lightingAttrib = new VertexAttribute<int[]>(){
        private int[] colourRef;

        @Override
        public int[] newArray(int length) {
            return new int[length];
        }

        @Override
        public boolean load(CCRenderState state) {
            if (!(state.computeLighting && state.useColour && state.model.hasAttribute(this))) {
                return false;
            }
            this.colourRef = state.model.getAttributes(this);
            if (this.colourRef != null) {
                state.pipeline.addDependency(CCRenderState.this.colourAttrib);
                return true;
            }
            return false;
        }

        @Override
        public void operate(CCRenderState state) {
            state.setColourInstance(ColourRGBA.multiply(state.colour, this.colourRef[state.vertexIndex]));
        }
    };
    public VertexAttribute<int[]> sideAttrib = new VertexAttribute<int[]>(){
        private int[] sideRef;

        @Override
        public int[] newArray(int length) {
            return new int[length];
        }

        @Override
        public boolean load(CCRenderState state) {
            this.sideRef = state.model.getAttributes(this);
            if (state.model.hasAttribute(this)) {
                return this.sideRef != null;
            }
            state.pipeline.addDependency(CCRenderState.this.normalAttrib);
            return true;
        }

        @Override
        public void operate(CCRenderState state) {
            state.side = this.sideRef != null ? this.sideRef[state.vertexIndex] : CCModel.findSide(state.normal);
        }
    };
    public VertexAttribute<LC[]> lightCoordAttrib = new VertexAttribute<LC[]>(){
        private LC[] lcRef;
        private final Vector3 vec = new Vector3();
        private final Vector3 pos = new Vector3();

        @Override
        public LC[] newArray(int length) {
            return new LC[length];
        }

        @Override
        public boolean load(CCRenderState state) {
            this.lcRef = state.model.getAttributes(this);
            if (state.model.hasAttribute(this)) {
                return this.lcRef != null;
            }
            this.pos.set(state.lightMatrix.pos.x, state.lightMatrix.pos.y, state.lightMatrix.pos.z);
            state.pipeline.addDependency(CCRenderState.this.sideAttrib);
            state.pipeline.addRequirement(Transformation.operationIndex);
            return true;
        }

        @Override
        public void operate(CCRenderState state) {
            if (this.lcRef != null) {
                state.lc.set(this.lcRef[state.vertexIndex]);
            } else {
                state.lc.compute(this.vec.set(state.vert.vec).sub(this.pos), state.side);
            }
        }
    };
    public IVertexSource model;
    public int firstVertexIndex;
    public int lastVertexIndex;
    public int vertexIndex;
    public int baseColour;
    public int alphaOverride;
    public boolean useNormals;
    public boolean computeLighting;
    public boolean useColour;
    public LightMatrix lightMatrix = new LightMatrix();
    public Vertex5 vert = new Vertex5();
    public boolean hasNormal;
    public Vector3 normal = new Vector3();
    public boolean hasColour;
    public int colour;
    public boolean hasBrightness;
    public int brightness;
    public int side;
    public LC lc = new LC();

    private CCRenderState() {
        this.pipeline = new CCRenderPipeline(this);
    }

    public static CCRenderState instance() {
        return instances.get();
    }

    public static int registerOperation() {
        return nextOperationIndex++;
    }

    public static int operationCount() {
        return nextOperationIndex;
    }

    private static int registerVertexAttribute(VertexAttribute<?> attr) {
        vertexAttributes.add(attr);
        return vertexAttributes.size() - 1;
    }

    public static VertexAttribute<?> getAttribute(int index) {
        return vertexAttributes.get(index);
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])dst;
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> T copyOf(VertexAttribute<T> attr, T src, int length) {
        T dst = attr.newArray(length);
        CCRenderState.arrayCopy(src, 0, dst, 0, ((Object[])src).length);
        return dst;
    }

    public static VertexAttribute<Vector3[]> normalAttrib() {
        return CCRenderState.instances.get().normalAttrib;
    }

    public static VertexAttribute<int[]> colourAttrib() {
        return CCRenderState.instances.get().colourAttrib;
    }

    public static VertexAttribute<LC[]> lightCoordAttrib() {
        return CCRenderState.instances.get().lightCoordAttrib;
    }

    public static VertexAttribute<int[]> sideAttrib() {
        return CCRenderState.instances.get().sideAttrib;
    }

    public static VertexAttribute<int[]> lightingAttrib() {
        return CCRenderState.instances.get().lightingAttrib;
    }

    public static void reset() {
        CCRenderState.instance().resetInstance();
    }

    public void resetInstance() {
        this.model = null;
        this.pipeline.reset();
        this.hasColour = false;
        this.hasBrightness = false;
        this.hasNormal = false;
        this.useNormals = false;
        this.computeLighting = true;
        this.useColour = true;
        this.alphaOverride = -1;
        this.baseColour = -1;
    }

    public void setPipelineInstance(IVertexOperation ... ops) {
        this.pipeline.setPipeline(ops);
    }

    @Deprecated
    public static void setPipeline(IVertexOperation ... ops) {
        CCRenderState.instance().setPipelineInstance(ops);
    }

    public void setPipelineInstance(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        this.pipeline.reset();
        this.setModelInstance(model, start, end);
        this.pipeline.setPipeline(ops);
    }

    @Deprecated
    public static void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        CCRenderState.instance().setPipelineInstance(model, start, end, ops);
    }

    public void bindModelInstance(IVertexSource model) {
        if (this.model != model) {
            this.model = model;
            this.pipeline.rebuild();
        }
    }

    @Deprecated
    public static void bindModel(IVertexSource model) {
        CCRenderState.instance().bindModelInstance(model);
    }

    public void setModelInstance(IVertexSource source) {
        this.setModelInstance(source, 0, source.getVertices().length);
    }

    @Deprecated
    public static void setModel(IVertexSource source) {
        CCRenderState.instance().setModelInstance(source);
    }

    public void setModelInstance(IVertexSource source, int start, int end) {
        this.bindModelInstance(source);
        this.setVertexRangeInstance(start, end);
    }

    @Deprecated
    public static void setModel(IVertexSource source, int start, int end) {
        CCRenderState.instance().setModelInstance(source, start, end);
    }

    public void setVertexRangeInstance(int start, int end) {
        this.firstVertexIndex = start;
        this.lastVertexIndex = end;
    }

    @Deprecated
    public static void setVertexRange(int start, int end) {
        CCRenderState.instance().setVertexRangeInstance(start, end);
    }

    public void renderInstance(IVertexOperation ... ops) {
        this.setPipelineInstance(ops);
        this.renderInstance();
    }

    @Deprecated
    public static void render(IVertexOperation ... ops) {
        CCRenderState.instance().renderInstance(ops);
    }

    public void renderInstance() {
        Vertex5[] verts = this.model.getVertices();
        this.vertexIndex = this.firstVertexIndex;
        while (this.vertexIndex < this.lastVertexIndex) {
            this.model.prepareVertex(this);
            this.vert.set(verts[this.vertexIndex]);
            this.runPipelineInstance();
            this.writeVertInstance();
            ++this.vertexIndex;
        }
    }

    @Deprecated
    public static void render() {
        CCRenderState.instance().renderInstance();
    }

    public void runPipelineInstance() {
        this.pipeline.operate();
    }

    @Deprecated
    public static void runPipeline() {
        CCRenderState.instance().runPipelineInstance();
    }

    public void writeVertInstance() {
        if (this.hasNormal) {
            Tessellator.instance.setNormal((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
        }
        if (this.hasColour) {
            Tessellator.instance.setColorRGBA(this.colour >>> 24, this.colour >> 16 & 0xFF, this.colour >> 8 & 0xFF, this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF);
        }
        if (this.hasBrightness) {
            Tessellator.instance.setBrightness(this.brightness);
        }
        Tessellator.instance.addVertexWithUV(this.vert.vec.x, this.vert.vec.y, this.vert.vec.z, this.vert.uv.u, this.vert.uv.v);
    }

    @Deprecated
    public static void writeVert() {
        CCRenderState.instance().writeVertInstance();
    }

    public void setNormalInstance(double x, double y, double z) {
        this.hasNormal = true;
        this.normal.set(x, y, z);
    }

    @Deprecated
    public static void setNormal(double x, double y, double z) {
        CCRenderState.instance().setNormalInstance(x, y, z);
    }

    public void setNormalInstance(Vector3 n) {
        this.hasNormal = true;
        this.normal.set(n);
    }

    @Deprecated
    public static void setNormal(Vector3 n) {
        CCRenderState.instance().setNormalInstance(n);
    }

    public void setColourInstance(int c) {
        this.hasColour = true;
        this.colour = c;
    }

    @Deprecated
    public static void setColour(int c) {
        CCRenderState.instance().setColourInstance(c);
    }

    public void setBrightnessInstance(int b) {
        this.hasBrightness = true;
        this.brightness = b;
    }

    @Deprecated
    public static void setBrightness(int b) {
        CCRenderState.instance().setBrightnessInstance(b);
    }

    public void setBrightnessInstance(IBlockAccess world, int x, int y, int z) {
        this.setBrightnessInstance(world.getBlock(x, y, z).getMixedBrightnessForBlock(world, x, y, z));
    }

    @Deprecated
    public static void setBrightness(IBlockAccess world, int x, int y, int z) {
        CCRenderState.instance().setBrightnessInstance(world, x, y, z);
    }

    public static void pullLightmap() {
        CCRenderState.instance().pullLightmapInstance();
    }

    public void pullLightmapInstance() {
        this.setBrightnessInstance((int)OpenGlHelper.lastBrightnessY << 16 | (int)OpenGlHelper.lastBrightnessX);
    }

    public static void pushLightmap() {
        CCRenderState.instance().pushLightmapInstance();
    }

    public void pushLightmapInstance() {
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)(this.brightness & 0xFFFF), (float)(this.brightness >>> 16));
    }

    public static void setDynamic() {
        CCRenderState.instance().setDynamicInstance();
    }

    public void setDynamicInstance() {
        this.useNormals = true;
        this.computeLighting = false;
    }

    public static void changeTexture(String texture) {
        CCRenderState.changeTexture(new ResourceLocation(texture));
    }

    public static void changeTexture(ResourceLocation texture) {
        Minecraft.getMinecraft().renderEngine.bindTexture(texture);
    }

    public void startDrawingInstance() {
        this.startDrawingInstance(7);
    }

    @Deprecated
    public static void startDrawing() {
        CCRenderState.instance().startDrawingInstance();
    }

    public void startDrawingInstance(int mode) {
        Tessellator.instance.startDrawing(mode);
        if (this.hasColour) {
            Tessellator.instance.setColorRGBA(this.colour >>> 24, this.colour >> 16 & 0xFF, this.colour >> 8 & 0xFF, this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF);
        }
        if (this.hasBrightness) {
            Tessellator.instance.setBrightness(this.brightness);
        }
    }

    @Deprecated
    public static void startDrawing(int mode) {
        CCRenderState.instance().startDrawingInstance(mode);
    }

    public static void draw() {
        Tessellator.instance.draw();
    }

    public void drawInstance() {
        Tessellator.instance.draw();
    }

    static /* synthetic */ int access$000(VertexAttribute x0) {
        return CCRenderState.registerVertexAttribute(x0);
    }

    static {
        vertexAttributes = new ArrayList();
    }

    public static abstract class VertexAttribute<T>
    implements IVertexOperation {
        public final int attributeIndex = CCRenderState.access$000(this);
        private final int operationIndex = CCRenderState.registerOperation();
        public boolean active = false;

        public abstract T newArray(int var1);

        @Override
        public int operationID() {
            return this.operationIndex;
        }
    }

    public static interface IVertexSource {
        public Vertex5[] getVertices();

        public <T> T getAttributes(VertexAttribute<T> var1);

        public boolean hasAttribute(VertexAttribute<?> var1);

        public void prepareVertex(CCRenderState var1);

        default public void prepareVertex() {
            this.prepareVertex(CCRenderState.instance());
        }
    }

    public static interface IVertexOperation {
        default public boolean load() {
            return this.load(CCRenderState.instance());
        }

        default public boolean load(CCRenderState state) {
            return this.load();
        }

        default public void operate() {
            this.operate(CCRenderState.instance());
        }

        default public void operate(CCRenderState state) {
            this.operate();
        }

        public int operationID();
    }
}

