/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class EntityDigIconFX
extends EntityFX {
    public EntityDigIconFX(World world, double x, double y, double z, double dx, double dy, double dz, IIcon icon) {
        super(world, x, y, z, dx, dy, dz);
        this.particleIcon = icon;
        this.particleGravity = 1.0f;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale /= 2.0f;
    }

    public int getFXLayer() {
        return 1;
    }

    public void setScale(float scale) {
        this.particleScale = scale;
    }

    public float getScale() {
        return this.particleScale;
    }

    public void setMaxAge(int age) {
        this.particleMaxAge = age;
    }

    public int getMaxAge() {
        return this.particleMaxAge;
    }

    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = ((float)this.particleTextureIndexX + this.particleTextureJitterX / 4.0f) / 16.0f;
        float f7 = f6 + 0.015609375f;
        float f8 = ((float)this.particleTextureIndexY + this.particleTextureJitterY / 4.0f) / 16.0f;
        float f9 = f8 + 0.015609375f;
        float f10 = 0.1f * this.particleScale;
        if (this.particleIcon != null) {
            f6 = this.particleIcon.getInterpolatedU((double)(this.particleTextureJitterX / 4.0f * 16.0f));
            f7 = this.particleIcon.getInterpolatedU((double)((this.particleTextureJitterX + 1.0f) / 4.0f * 16.0f));
            f8 = this.particleIcon.getInterpolatedV((double)(this.particleTextureJitterY / 4.0f * 16.0f));
            f9 = this.particleIcon.getInterpolatedV((double)((this.particleTextureJitterY + 1.0f) / 4.0f * 16.0f));
        }
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)par2 - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)par2 - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)par2 - interpPosZ);
        float f14 = 1.0f;
        par1Tessellator.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        par1Tessellator.addVertexWithUV((double)(f11 - par3 * f10 - par6 * f10), (double)(f12 - par4 * f10), (double)(f13 - par5 * f10 - par7 * f10), (double)f6, (double)f9);
        par1Tessellator.addVertexWithUV((double)(f11 - par3 * f10 + par6 * f10), (double)(f12 + par4 * f10), (double)(f13 - par5 * f10 + par7 * f10), (double)f6, (double)f8);
        par1Tessellator.addVertexWithUV((double)(f11 + par3 * f10 + par6 * f10), (double)(f12 + par4 * f10), (double)(f13 + par5 * f10 + par7 * f10), (double)f7, (double)f8);
        par1Tessellator.addVertexWithUV((double)(f11 + par3 * f10 - par6 * f10), (double)(f12 - par4 * f10), (double)(f13 + par5 * f10 - par7 * f10), (double)f7, (double)f9);
    }

    public static void addBlockHitEffects(World world, Cuboid6 bounds, int side, IIcon icon, EffectRenderer effectRenderer) {
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add(-2.0f * border);
        diff.x *= world.rand.nextDouble();
        diff.y *= world.rand.nextDouble();
        diff.z *= world.rand.nextDouble();
        Vector3 pos = diff.add(bounds.min).add(border);
        if (side == 0) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == 1) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == 2) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == 3) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == 4) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == 5) {
            diff.x = bounds.max.x + (double)border;
        }
        effectRenderer.addEffect(new EntityDigIconFX(world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
    }

    public static void addBlockDestroyEffects(World world, Cuboid6 bounds, IIcon[] icons, EffectRenderer effectRenderer) {
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0);
        density.x = Math.ceil(density.x);
        density.y = Math.ceil(density.y);
        density.z = Math.ceil(density.z);
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    effectRenderer.addEffect((EntityFX)new EntityDigIconFX(world, x, y, z, x - center.x, y - center.y, z - center.z, icons[world.rand.nextInt(icons.length)]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

