/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class FontUtils {
    public static FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
    public static final String[] prefixes = new String[]{"K", "M", "G"};

    public static void drawCenteredString(String s, int xCenter, int y, int colour) {
        fontRenderer.drawString(s, xCenter - fontRenderer.getStringWidth(s) / 2, y, colour);
    }

    public static void drawRightString(String s, int xRight, int y, int colour) {
        fontRenderer.drawString(s, xRight - fontRenderer.getStringWidth(s), y, colour);
    }

    public static void drawItemQuantity(int x, int y, ItemStack item, String quantity, int mode) {
        if (item == null || quantity == null && item.stackSize <= 1) {
            return;
        }
        if (quantity == null) {
            switch (mode) {
                case 2: {
                    int q = item.stackSize;
                    String postfix = "";
                    for (int p = 0; p < 3 && q > 1000; q /= 1000, ++p) {
                        postfix = prefixes[p];
                    }
                    quantity = Integer.toString(q) + postfix;
                }
                case 1: {
                    quantity = "";
                    if (item.stackSize / 64 > 0) {
                        quantity = quantity + item.stackSize / 64 + "s";
                    }
                    if (item.stackSize % 64 <= 0) break;
                    quantity = quantity + item.stackSize % 64;
                    break;
                }
                default: {
                    quantity = Integer.toString(item.stackSize);
                }
            }
        }
        double scale = quantity.length() > 2 ? 0.5 : 1.0;
        double sheight = 8.0 * scale;
        double swidth = (double)fontRenderer.getStringWidth(quantity) * scale;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)(x + 16) - swidth), (double)((double)(y + 16) - sheight), (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)1.0);
        fontRenderer.drawStringWithShadow(quantity, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }
}

