/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static RenderItem uniformRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };
    static EntityItem entityItem;

    @Deprecated
    public static void renderFluidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, IIcon icon, double res) {
        RenderUtils.renderFluidQuad(point2.x, point2.y, point2.z, point4.x - point1.x, point4.y - point1.y, point4.z - point1.z, point1.x - point2.x, point1.y - point2.y, point1.z - point2.z, icon, res);
    }

    @Deprecated
    public static void renderFluidQuad(Vector3 base, Vector3 wide, Vector3 high, IIcon icon, double res) {
        RenderUtils.renderFluidQuad(base.x, base.y, base.z, wide.x, wide.y, wide.z, wide.x, wide.y, wide.z, icon, res);
    }

    public static void renderFluidQuad(double baseX, double baseY, double baseZ, double wideX, double wideY, double wideZ, double highX, double highY, double highZ, IIcon icon, double res) {
        double rx;
        Tessellator tessellator = Tessellator.instance;
        double u = icon.getMinU();
        double du = icon.getMaxU() - icon.getMinU();
        double v = icon.getMinV();
        double dv = icon.getMaxV() - icon.getMinV();
        double wideLen = Math.sqrt(wideX * wideX + wideY * wideY + wideZ * wideZ);
        double highLen = Math.sqrt(highX * highX + highY * highY + highZ * highZ);
        for (double x = 0.0; x < wideLen; x += rx) {
            double ry;
            rx = wideLen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < highLen; y += ry) {
                ry = highLen - y;
                if (ry > res) {
                    ry = res;
                }
                double mult1 = x / wideLen;
                double dx1X = wideX * mult1;
                double dx1Y = wideY * mult1;
                double dx1Z = wideZ * mult1;
                double mult2 = (x + rx) / wideLen;
                double dx2X = wideX * mult2;
                double dx2Y = wideY * mult2;
                double dx2Z = wideZ * mult2;
                double mult3 = y / highLen;
                double dy1X = highX * mult3;
                double dy1Y = highY * mult3;
                double dy1Z = highZ * mult3;
                double mult4 = (y + ry) / highLen;
                double dy2X = highX * mult4;
                double dy2Y = highY * mult4;
                double dy2Z = highZ * mult4;
                tessellator.addVertexWithUV(baseX + dx1X + dy2X, baseY + dx1Y + dy2Y, baseZ + dx1Z + dy2Z, u, v + ry / res * dv);
                tessellator.addVertexWithUV(baseX + dx1X + dy1X, baseY + dx1Y + dy1Y, baseZ + dx1Z + dy1Z, u, v);
                tessellator.addVertexWithUV(baseX + dx2X + dy1X, baseY + dx2Y + dy1Y, baseZ + dx2Z + dy1Z, u + rx / res * du, v);
                tessellator.addVertexWithUV(baseX + dx2X + dy2X, baseY + dx2Y + dy2Y, baseZ + dx2Z + dy2Z, u + rx / res * du, v + ry / res * dv);
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float partialTicks) {
        double interpPosX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)partialTicks;
        double interpPosY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)partialTicks;
        double interpPosZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)partialTicks;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawCuboidOutline(Cuboid6 c) {
        Tessellator tess = Tessellator.instance;
        tess.startDrawing(3);
        tess.addVertex(c.min.x, c.min.y, c.min.z);
        tess.addVertex(c.max.x, c.min.y, c.min.z);
        tess.addVertex(c.max.x, c.min.y, c.max.z);
        tess.addVertex(c.min.x, c.min.y, c.max.z);
        tess.addVertex(c.min.x, c.min.y, c.min.z);
        tess.draw();
        tess.startDrawing(3);
        tess.addVertex(c.min.x, c.max.y, c.min.z);
        tess.addVertex(c.max.x, c.max.y, c.min.z);
        tess.addVertex(c.max.x, c.max.y, c.max.z);
        tess.addVertex(c.min.x, c.max.y, c.max.z);
        tess.addVertex(c.min.x, c.max.y, c.min.z);
        tess.draw();
        tess.startDrawing(1);
        tess.addVertex(c.min.x, c.min.y, c.min.z);
        tess.addVertex(c.min.x, c.max.y, c.min.z);
        tess.addVertex(c.max.x, c.min.y, c.min.z);
        tess.addVertex(c.max.x, c.max.y, c.min.z);
        tess.addVertex(c.max.x, c.min.y, c.max.z);
        tess.addVertex(c.max.x, c.max.y, c.max.z);
        tess.addVertex(c.min.x, c.min.y, c.max.z);
        tess.addVertex(c.min.x, c.max.y, c.max.z);
        tess.draw();
    }

    public static void renderFluidCuboid(CCRenderState state, Cuboid6 bound, IIcon tex, double res) {
        RenderUtils.renderFluidCuboid(bound, tex, res);
    }

    public static void renderFluidCuboid(Cuboid6 bound, IIcon tex, double res) {
        double minX = bound.min.x;
        double minY = bound.min.y;
        double minZ = bound.min.z;
        double maxX = bound.max.x;
        double maxY = bound.max.y;
        double maxZ = bound.max.z;
        RenderUtils.renderFluidQuad(minX, minY, minZ, maxX - minX, 0.0, 0.0, 0.0, 0.0, maxZ - minZ, tex, res);
        RenderUtils.renderFluidQuad(minX, maxY, minZ, 0.0, 0.0, maxZ - minZ, maxX - minX, 0.0, 0.0, tex, res);
        RenderUtils.renderFluidQuad(minX, maxY, minZ, 0.0, minY - maxY, 0.0, 0.0, 0.0, maxZ - minZ, tex, res);
        RenderUtils.renderFluidQuad(maxX, maxY, maxZ, 0.0, minY - maxY, 0.0, 0.0, 0.0, minZ - maxZ, tex, res);
        RenderUtils.renderFluidQuad(maxX, maxY, minZ, 0.0, minY - maxY, 0.0, minX - maxX, 0.0, 0.0, tex, res);
        RenderUtils.renderFluidQuad(minX, maxY, maxZ, 0.0, minY - maxY, 0.0, maxX - minX, 0.0, 0.0, tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        Tessellator tessellator = Tessellator.instance;
        double minX = (double)x - 0.009;
        double maxX = (double)x + 1.009;
        double minY = (double)y - 0.009;
        double maxY = (double)y + 1.009;
        double minZ = (double)z - 0.009;
        double maxZ = (double)z + 1.009;
        switch (side) {
            case 0: {
                tessellator.addVertexWithUV(minX, minY, minZ, tx1, ty1);
                tessellator.addVertexWithUV(maxX, minY, minZ, tx2, ty1);
                tessellator.addVertexWithUV(maxX, minY, maxZ, tx2, ty2);
                tessellator.addVertexWithUV(minX, minY, maxZ, tx1, ty2);
                break;
            }
            case 1: {
                tessellator.addVertexWithUV(maxX, maxY, minZ, tx2, ty1);
                tessellator.addVertexWithUV(minX, maxY, minZ, tx1, ty1);
                tessellator.addVertexWithUV(minX, maxY, maxZ, tx1, ty2);
                tessellator.addVertexWithUV(maxX, maxY, maxZ, tx2, ty2);
                break;
            }
            case 2: {
                tessellator.addVertexWithUV(minX, maxY, minZ, tx2, ty1);
                tessellator.addVertexWithUV(maxX, maxY, minZ, tx1, ty1);
                tessellator.addVertexWithUV(maxX, minY, minZ, tx1, ty2);
                tessellator.addVertexWithUV(minX, minY, minZ, tx2, ty2);
                break;
            }
            case 3: {
                tessellator.addVertexWithUV(maxX, maxY, maxZ, tx2, ty1);
                tessellator.addVertexWithUV(minX, maxY, maxZ, tx1, ty1);
                tessellator.addVertexWithUV(minX, minY, maxZ, tx1, ty2);
                tessellator.addVertexWithUV(maxX, minY, maxZ, tx2, ty2);
                break;
            }
            case 4: {
                tessellator.addVertexWithUV(minX, maxY, maxZ, tx2, ty1);
                tessellator.addVertexWithUV(minX, maxY, minZ, tx1, ty1);
                tessellator.addVertexWithUV(minX, minY, minZ, tx1, ty2);
                tessellator.addVertexWithUV(minX, minY, maxZ, tx2, ty2);
                break;
            }
            case 5: {
                tessellator.addVertexWithUV(maxX, maxY, minZ, tx2, ty1);
                tessellator.addVertexWithUV(maxX, maxY, maxZ, tx1, ty1);
                tessellator.addVertexWithUV(maxX, minY, maxZ, tx1, ty2);
                tessellator.addVertexWithUV(maxX, minY, minZ, tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderFluid(FluidStack stack) {
        return stack.amount > 0 && stack.getFluid() != null;
    }

    public static IIcon prepareFluidRender(CCRenderState state, FluidStack stack, int alpha) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Fluid fluid = stack.getFluid();
        state.setColourInstance(fluid.getColor(stack) << 8 | alpha);
        TextureUtils.bindAtlas(fluid.getSpriteNumber());
        return TextureUtils.safeIcon(fluid.getIcon(stack));
    }

    public static IIcon prepareFluidRender(FluidStack stack, int alpha) {
        return RenderUtils.prepareFluidRender(CCRenderState.instance(), stack, alpha);
    }

    public static void postFluidRender() {
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static double fluidDensityToAlpha(double d) {
        return Math.pow(d, 0.4);
    }

    public static void renderFluidCuboid(CCRenderState state, FluidStack stack, Cuboid6 bound, double fillRate, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        fillRate = MathHelper.clamp_double((double)fillRate, (double)0.0, (double)1.0);
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(fillRate) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * fillRate;
        }
        IIcon tex = RenderUtils.prepareFluidRender(state, stack, alpha);
        state.startDrawingInstance();
        RenderUtils.renderFluidCuboid(bound, tex, res);
        state.drawInstance();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidCuboid(FluidStack stack, Cuboid6 bound, double fillRate, double res) {
        RenderUtils.renderFluidCuboid(CCRenderState.instance(), stack, bound, fillRate, res);
    }

    public static void renderFluidGauge(CCRenderState state, FluidStack stack, Rectangle4i rect, double fillRate, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        fillRate = MathHelper.clamp_double((double)fillRate, (double)0.0, (double)1.0);
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(fillRate) * 255.0);
        } else {
            int height = (int)((double)rect.h * fillRate);
            rect.y += rect.h - height;
            rect.h = height;
        }
        IIcon tex = RenderUtils.prepareFluidRender(state, stack, alpha);
        state.startDrawingInstance();
        RenderUtils.renderFluidQuad(rect.x, rect.y + rect.h, 0.0, rect.w, 0.0, 0.0, 0.0, -rect.h, 0.0, tex, res);
        state.drawInstance();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack stack, Rectangle4i rect, double fillRate, double res) {
        RenderUtils.renderFluidGauge(CCRenderState.instance(), stack, rect, fillRate, res);
    }

    public static void renderItemUniform(ItemStack item) {
        RenderUtils.renderItemUniform(item, 0.0);
    }

    public static void renderItemUniform(ItemStack item, double spin) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (item.getItem() instanceof ItemBlock && RenderBlocks.renderItemIn3d((int)Block.getBlockFromItem((Item)item.getItem()).getRenderType())) {
            int renderType = Block.getBlockFromItem((Item)item.getItem()).getRenderType();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        } else if (is3D) {
            larger = true;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.setEntityItemStack(item);
        uniformRenderItem.doRender(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, (float)(spin * 9.0 / Math.PI));
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    static {
        uniformRenderItem.setRenderManager(RenderManager.instance);
        entityItem = new EntityItem(null);
        RenderUtils.entityItem.hoverStart = 0.0f;
    }
}

