package thelm.packagedexcrafting.slot;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.SlotItemHandler;
import thelm.packagedexcrafting.block.entity.EliteCrafterBlockEntity;

//Code from CoFHCore
public class EliteCrafterRemoveOnlySlot extends SlotItemHandler {

	public final EliteCrafterBlockEntity blockEntity;

	public EliteCrafterRemoveOnlySlot(EliteCrafterBlockEntity blockEntity, int index, int x, int y) {
		super(blockEntity.getItemHandler(), index, x, y);
		this.blockEntity = blockEntity;
	}

	@Override
	public boolean mayPickup(Player player) {
		return !blockEntity.isWorking;
	}

	@Override
	public boolean mayPlace(ItemStack stack) {
		return false;
	}
}
