/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.registry;

import cc.cassian.pyrite.functions.ModHelpers;
import cc.cassian.pyrite.functions.ModLists;
import cc.cassian.pyrite.registry.fabric.BlockCreatorImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;

public class BlockCreator {
    static final class_2248[] vanillaWood = ModLists.getVanillaWood();
    static final class_2248[] resource_blocks = ModLists.getVanillaResourceBlocks();

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformRegister(String blockID, String blockType, class_4970.class_2251 blockSettings, class_4719 woodType, class_8177 blockSetType, class_2394 particle, class_2248 copyBlock, String group, class_3620 color) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        BlockCreatorImpl.platformRegister(blockID, (String)var1_1, (class_4970.class_2251)var2_2, (class_4719)var3_3, (class_8177)var4_4, (class_2394)var5_5, (class_2248)var6_6, (String)var7_7, (class_3620)var8_8);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPyriteItem(String itemID) {
        BlockCreatorImpl.registerPyriteItem(itemID);
    }

    public static void generateResourceBlocks() {
        for (class_2248 resourceBlock : resource_blocks) {
            String block = ModHelpers.findVanillaBlockID(resourceBlock);
            if (block.contains("block")) {
                block = block.substring(0, block.indexOf("_block"));
            }
            BlockCreator.createResourceBlockSet(block, resourceBlock);
        }
    }

    public static void createTorchLever(String blockID, class_2248 baseTorch, class_2394 particle) {
        BlockCreator.sendToRegistry(blockID, "torch_lever", class_4970.class_2251.method_9630((class_4970)baseTorch), particle, "torch_lever");
    }

    public static void createTorch(String blockID, class_2394 particle) {
        BlockCreator.sendToRegistry(blockID, "torch", class_4970.class_2251.method_9630((class_4970)class_2246.field_10336), particle, "torch");
    }

    public static void generateVanillaCraftingTables() {
        for (class_2248 plankBlock : vanillaWood) {
            String block = ModHelpers.findVanillaBlockID(plankBlock);
            if (block.contains("planks")) {
                block = block.substring(0, block.indexOf("_planks"));
            }
            BlockCreator.createPyriteBlock(block + "_crafting_table", "crafting", plankBlock, "crafting_table");
        }
    }

    public static void createPyriteBlock(String blockID, String blockType, Float strength, class_3620 color, int lightLevel, String group) {
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_9632(strength.floatValue()).method_9631(state -> lightLevel).method_31710(color);
        if (Objects.equals(blockType, "obsidian")) {
            BlockCreator.sendToRegistry(blockID, "block", settings.method_9629(strength.floatValue(), 1200.0f).method_50012(class_3619.field_15972), group);
        } else if (blockType.equals("lamp")) {
            BlockCreator.sendToRegistry(blockID, blockType, settings.method_9626(class_2498.field_11537), group);
        } else {
            BlockCreator.sendToRegistry(blockID, blockType, settings.method_9626(class_2498.field_11537).method_22488().method_26236(BlockCreator::never), group);
        }
    }

    private static boolean never(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    private static void createCarpet(String blockID, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(class_2246.field_28680);
        BlockCreator.sendToRegistry(blockID, "carpet", blockSettings, group);
    }

    public static void createPyriteBlock(String blockID, String blockType, class_2248 copyBlock, String group) {
        BlockCreator.platformRegister(blockID, blockType, ModHelpers.copyBlock(copyBlock), class_4719.field_22183, class_8177.field_42819, null, copyBlock, group, null);
    }

    public static void createStair(String blockID, class_2248 copyBlock, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(copyBlock);
        BlockCreator.sendToRegistry(blockID + "_stairs", copyBlock, blockSettings, group);
    }

    public static void createSlab(String blockID, class_2248 copyBlock, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(copyBlock);
        BlockCreator.sendToRegistry(blockID + "_slab", "slab", blockSettings, group);
    }

    public static void createPyriteBlock(String blockID, String blockType, class_2248 copyBlock, int lux, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(copyBlock).method_9631(ModHelpers.parseLux(lux));
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, null, copyBlock, group, null);
    }

    private static void sendToRegistry(String blockID, String blockType, class_4970.class_2251 blockSettings, String group) {
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, null, null, group, null);
    }

    private static void sendToRegistry(String blockID, class_2248 copyBlock, class_4970.class_2251 blockSettings, String group) {
        BlockCreator.platformRegister(blockID, "stairs", blockSettings, null, null, null, copyBlock, group, null);
    }

    private static void sendToRegistry(String blockID, String blockType, class_4970.class_2251 blockSettings, class_2394 particle, String group) {
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, particle, null, group, null);
    }

    public static void createPyriteBlock(String blockID, String blockType, class_2248 copyBlock, class_8177 set, String group) {
        BlockCreator.platformRegister(blockID, blockType, ModHelpers.copyBlock(copyBlock), null, set, null, copyBlock, group, null);
    }

    public static void createPyriteBlock(String blockID, String blockType, class_2248 copyBlock, class_3620 color, int lux, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(copyBlock).method_31710(color).method_9631(ModHelpers.parseLux(lux));
        if (copyBlock.equals(class_2246.field_10161) || copyBlock.equals(class_2246.field_10119) || copyBlock.equals(class_2246.field_10563)) {
            blockSettings = blockSettings.method_50013();
        }
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, null, copyBlock, group, color);
    }

    public static void createPyriteBlock(String blockID, class_2248 copyBlock, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(copyBlock);
        BlockCreator.platformRegister(blockID, "block", blockSettings, null, null, null, null, group, null);
    }

    public static void createPyriteBlock(String blockID, String blockType, class_2248 copyBlock, class_3620 color, int lux, class_8177 set, class_4719 type, String group) {
        class_4970.class_2251 blockSettings = ModHelpers.copyBlock(copyBlock).method_31710(color).method_9631(ModHelpers.parseLux(lux));
        if (!blockType.equals("button")) {
            blockSettings = blockSettings.method_50013();
        }
        BlockCreator.platformRegister(blockID, blockType, blockSettings, type, set, null, null, group, color);
    }

    public static void generateFlowers() {
        for (Map.Entry<String, class_2248> entry : ModLists.FLOWERS.entrySet()) {
            BlockCreator.createPyriteBlock(entry.getKey(), "flower", entry.getValue(), "flower");
        }
    }

    public static void generateTurfSets() {
        for (Map.Entry<String, class_2248> entry : ModLists.TURF_SETS.entrySet()) {
            BlockCreator.createTurfSet(entry.getKey(), entry.getValue());
        }
    }

    public static void generateNostalgiaBlocks() {
        for (Map.Entry<String, class_2248> entry : ModLists.NOSTALGIA_BLOCKS.entrySet()) {
            BlockCreator.createPyriteBlock(entry.getKey(), "block", entry.getValue(), entry.getKey());
        }
        BlockCreator.createPyriteBlock("nostalgia_gravel", "gravel", class_2246.field_10255, "gravel");
    }

    public static void generateBrickSet(String blockID, class_2248 copyBlock, class_3620 color, int lux, @Nullable String group) {
        if (group == null) {
            group = blockID;
        }
        BlockCreator.createPyriteBlock(blockID + "s", "block", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_stairs", "stairs", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_slab", "slab", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_wall", "wall", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_wall_gate", "wall_gate", copyBlock, class_8177.field_42821, group);
    }

    public static void generateBrickSet(String blockID, class_2248 copyBlock, class_3620 color) {
        BlockCreator.generateBrickSet(blockID, copyBlock, color, 0, blockID);
    }

    public static void generateBrickSet(String blockID, class_2248 copyBlock) {
        BlockCreator.generateBrickSet(blockID, copyBlock, copyBlock.method_26403());
    }

    public static void generateBrickSet(String blockID, class_2248 copyBlock, class_3620 color, boolean generateMossySet, String group) {
        BlockCreator.generateBrickSet(blockID, copyBlock, color, 0, group);
        if (generateMossySet) {
            BlockCreator.generateBrickSet("mossy_" + blockID, copyBlock, color, 0, null);
        }
    }

    public static void generateBrickSet(String blockID, class_2248 copyBlock, class_3620 color, boolean generateMossySet) {
        BlockCreator.generateBrickSet(blockID, copyBlock, color, generateMossySet, blockID);
    }

    public static void createTurfSet(String blockID, class_2248 copyBlock) {
        BlockCreator.createPyriteBlock(blockID + "_turf", "block", copyBlock, blockID);
        BlockCreator.createStair(blockID, copyBlock, blockID);
        BlockCreator.createSlab(blockID, copyBlock, blockID);
        BlockCreator.createCarpet(blockID + "_carpet", blockID);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_4719 createWoodType(String blockID, class_8177 setType) {
        void var1_1;
        return BlockCreatorImpl.createWoodType(blockID, (class_8177)var1_1);
    }

    public static void createWoodSet(String blockID, class_3620 color, int blockLux, String group) {
        class_8177 GENERATED_SET = new class_8177(blockID);
        class_4719 GENERATED_TYPE = BlockCreator.createWoodType(blockID, GENERATED_SET);
        BlockCreator.createPyriteBlock("%s_planks".formatted(blockID), "block", class_2246.field_10161, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_stairs".formatted(blockID), "stairs", class_2246.field_10563, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_slab".formatted(blockID), "slab", class_2246.field_10119, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_fence".formatted(blockID), "fence", class_2246.field_10620, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_fence_gate".formatted(blockID), "fence_gate", class_2246.field_10188, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_door".formatted(blockID), "door", class_2246.field_10149, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_trapdoor".formatted(blockID), "trapdoor", class_2246.field_10137, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_pressure_plate".formatted(blockID), "pressure_plate", class_2246.field_10484, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_button".formatted(blockID), "button", class_2246.field_10057, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_crafting_table".formatted(blockID), "crafting", class_2246.field_9980, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_ladder".formatted(blockID), "ladder", class_2246.field_9983, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_sign".formatted(blockID), "sign", class_2246.field_10121, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_hanging_sign".formatted(blockID), "hanging_sign", class_2246.field_40262, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_chest".formatted(blockID), "chest", class_2246.field_10034, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
    }

    public static void createWoodSetWithLog(String blockID, class_3620 color, int blockLux) {
        BlockCreator.createPyriteBlock("%s_log".formatted(blockID), "log", class_2246.field_10431, color, blockLux, "wood");
        BlockCreator.createPyriteBlock("stripped_%s_log".formatted(blockID), "log", class_2246.field_10519, color, blockLux, "wood");
        BlockCreator.createPyriteBlock("%s_wood".formatted(blockID), "wood", class_2246.field_10126, color, blockLux, "wood");
        BlockCreator.createPyriteBlock("stripped_%s_wood".formatted(blockID), "wood", class_2246.field_10250, color, blockLux, "wood");
        BlockCreator.createWoodSet(blockID, color, blockLux, "wood");
    }

    public static void createCutBlocks(String blockID, class_2248 block) {
        String cutBlockID = "cut_" + blockID;
        if (!blockID.contains("copper")) {
            BlockCreator.createPyriteBlock(cutBlockID, block, blockID);
            BlockCreator.createStair(cutBlockID, block, blockID);
            BlockCreator.createSlab(cutBlockID, block, blockID);
        }
        BlockCreator.createPyriteBlock("%s_wall".formatted(cutBlockID), "wall", block, blockID);
        BlockCreator.createPyriteBlock("%s_wall_gate".formatted(cutBlockID), "wall_gate", block, blockID);
    }

    public static void createSmoothBlocks(String blockID, class_2248 block) {
        String smoothBlockID = "smooth_" + blockID;
        if (!Objects.equals(blockID, "quartz")) {
            BlockCreator.createPyriteBlock(smoothBlockID, block, blockID);
            BlockCreator.createStair(smoothBlockID, block, blockID);
            BlockCreator.createSlab(smoothBlockID, block, blockID);
        }
        BlockCreator.createPyriteBlock("%s_wall".formatted(smoothBlockID), "wall", block, blockID);
        BlockCreator.createPyriteBlock("%s_wall_gate".formatted(smoothBlockID), "wall_gate", block, blockID);
    }

    public static void createResourceBlockSet(String blockID, class_2248 block) {
        BlockCreator.createCutBlocks(blockID, block);
        if (!Objects.equals(blockID, "quartz")) {
            BlockCreator.createPyriteBlock("%s_bricks".formatted(blockID), block, blockID);
            if (!blockID.contains("copper")) {
                BlockCreator.createPyriteBlock("chiseled_%s_block".formatted(blockID), "log", block, blockID);
            }
            BlockCreator.createPyriteBlock("%s_pillar".formatted(blockID), "log", block, blockID);
        }
        BlockCreator.createSmoothBlocks(blockID, block);
        BlockCreator.createPyriteBlock("nostalgia_%s_block".formatted(blockID), block, blockID);
        class_8177 set = ModHelpers.getBlockSetType(blockID);
        if (!blockID.equals("iron")) {
            BlockCreator.createPyriteBlock("%s_bars".formatted(blockID), "bars", block, blockID);
            if (!blockID.contains("copper")) {
                BlockCreator.createPyriteBlock("%s_door".formatted(blockID), "door", block, set, blockID);
                BlockCreator.createPyriteBlock("%s_trapdoor".formatted(blockID), "trapdoor", block, set, blockID);
            }
            if (!blockID.equals("gold")) {
                BlockCreator.createPyriteBlock("%s_pressure_plate".formatted(blockID), "pressure_plate", block, set, blockID);
            }
        }
        BlockCreator.createPyriteBlock("%s_button".formatted(blockID), "button", block, set, blockID);
    }
}

