/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite;

import cc.cassian.pyrite.functions.ModHelpers;
import cc.cassian.pyrite.functions.ModLists;
import cc.cassian.pyrite.registry.BlockCreator;
import java.util.Arrays;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Pyrite {
    public static final String MOD_ID = "pyrite";
    public static final Logger LOGGER = LogManager.getLogger((String)"Pyrite");

    public static void init() {
        ModLists.populateLinkedHashMaps();
        BlockCreator.createPyriteBlock("framed_glass", "glass", Float.valueOf(2.0f), MapColor.NONE, 0, "framed_glass");
        BlockCreator.createPyriteBlock("framed_glass_pane", "glass_pane", Float.valueOf(2.0f), MapColor.NONE, 0, "framed_glass_pane");
        BlockCreator.createPyriteBlock("switchable_glass", "switchable_glass", Blocks.GLASS, "redstone-group");
        BlockCreator.generateBrickSet("cobblestone_brick", Blocks.COBBLESTONE, MapColor.STONE, true);
        BlockCreator.generateBrickSet("cobbled_deepslate_brick", Blocks.COBBLESTONE, MapColor.STONE, true);
        BlockCreator.createPyriteBlock("smooth_stone_stairs", "stairs", Blocks.SMOOTH_STONE, "building_blocks");
        BlockCreator.generateBrickSet("smooth_stone_brick", Blocks.SMOOTH_STONE, MapColor.STONE, true);
        BlockCreator.generateBrickSet("granite_brick", Blocks.GRANITE, MapColor.DIRT, true);
        BlockCreator.generateBrickSet("andesite_brick", Blocks.ANDESITE, MapColor.STONE, true);
        BlockCreator.generateBrickSet("diorite_brick", Blocks.DIORITE, MapColor.QUARTZ, true);
        BlockCreator.generateBrickSet("calcite_brick", Blocks.CALCITE, MapColor.QUARTZ, true);
        BlockCreator.generateBrickSet("mossy_tuff_brick", Blocks.TUFF_BRICKS);
        BlockCreator.generateBrickSet("mossy_deepslate_brick", Blocks.DEEPSLATE_BRICKS);
        BlockCreator.generateBrickSet("sandstone_brick", Blocks.SANDSTONE);
        BlockCreator.generateBrickSet("terracotta_brick", Blocks.TERRACOTTA);
        BlockCreator.generateTurfSets();
        BlockCreator.createPyriteBlock("nether_brick_fence_gate", "fence_gate", Blocks.NETHER_BRICK_FENCE, "building_blocks");
        BlockCreator.generateResourceBlocks();
        BlockCreator.createTorchLever("torch_lever", Blocks.TORCH, (ParticleOptions)ParticleTypes.FLAME);
        BlockCreator.createTorchLever("redstone_torch_lever", Blocks.SOUL_TORCH, (ParticleOptions)DustParticleOptions.REDSTONE);
        BlockCreator.createTorchLever("soul_torch_lever", Blocks.SOUL_TORCH, (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME);
        BlockCreator.createPyriteBlock("lit_redstone_lamp", "lamp", Blocks.REDSTONE_LAMP, 15, "functional");
        BlockCreator.createPyriteBlock("glowstone_lamp", "lamp", Blocks.GLOWSTONE, 15, "functional");
        BlockCreator.createPyriteBlock("glowing_obsidian", "obsidian", Float.valueOf(50.0f), MapColor.COLOR_RED, 15, "obsidian");
        BlockCreator.createPyriteBlock("nostalgia_glowing_obsidian", "obsidian", Float.valueOf(50.0f), MapColor.COLOR_RED, 15, "obsidian");
        BlockCreator.createPyriteBlock("locked_chest", "facing", Blocks.CHEST, 15, "functional");
        BlockCreator.generateNostalgiaBlocks();
        BlockCreator.generateFlowers();
        BlockCreator.generateBrickSet("blue_nether_brick", Blocks.NETHER_BRICKS, MapColor.COLOR_BLUE, 0, "coloured_nether_bricks");
        BlockCreator.generateBrickSet("charred_nether_brick", Blocks.NETHER_BRICKS, MapColor.COLOR_BLACK, 0, "coloured_nether_bricks");
        BlockCreator.generateVanillaCraftingTables();
        if (ModHelpers.isModLoaded("aether")) {
            BlockCreator.createPyriteBlock("skyroot_crafting_table", "crafting", Blocks.CRAFTING_TABLE, "crafting_table");
            BlockCreator.createPyriteBlock("holystone_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("mossy_holystone_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("holystone_brick_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("icestone_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("aerogel_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("carved_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("angelic_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
            BlockCreator.createPyriteBlock("hellfire_wall_gate", "wall_gate", Blocks.STONE, BlockSetType.STONE, "misc");
        }
        BlockCreator.createPyriteBlock("red_mushroom_stem", "log", Blocks.MUSHROOM_STEM, "red_mushroom");
        BlockCreator.createWoodSet("red_mushroom", MapColor.COLOR_RED, 0, "wood");
        BlockCreator.createPyriteBlock("brown_mushroom_stem", "log", Blocks.MUSHROOM_STEM, "brown_mushroom");
        BlockCreator.createWoodSet("brown_mushroom", MapColor.COLOR_BROWN, 0, "wood");
        BlockCreator.createWoodSetWithLog("azalea", MapColor.CRIMSON_NYLIUM, 0);
        for (int dyeIndex = 0; dyeIndex < ModLists.DYES.length; ++dyeIndex) {
            String dye = ModLists.DYES[dyeIndex];
            int blockLux = ModHelpers.checkDyeLux(dye);
            MapColor color = ModHelpers.checkDyeMapColour(dye);
            boolean VANILLA_DYE = Arrays.asList(ModLists.VANILLA_DYES).contains(dye);
            if (!VANILLA_DYE) {
                BlockCreator.registerPyriteItem(dye + "_dye");
                BlockCreator.createPyriteBlock(dye + "_wool", "block", ModLists.WOOL_MATCH.getOrDefault(dye, Blocks.WHITE_WOOL), color, blockLux, "colored_blocks");
                BlockCreator.createPyriteBlock(dye + "_carpet", "carpet", ModLists.CARPET_MATCH.getOrDefault(dye, Blocks.WHITE_CARPET), color, blockLux, "colored_blocks");
                BlockCreator.createPyriteBlock(dye + "_concrete", "block", ModLists.CONCRETE_MATCH.getOrDefault(dye, Blocks.WHITE_CONCRETE), color, blockLux, "concrete");
                BlockCreator.createPyriteBlock(dye + "_concrete_powder", "concrete_powder", Blocks.WHITE_CONCRETE_POWDER, color, blockLux, "concrete_powder");
            }
            BlockCreator.createPyriteBlock(dye + "_concrete_stairs", "stairs", Blocks.WHITE_CONCRETE, color, blockLux, "concrete_stairs");
            BlockCreator.createPyriteBlock(dye + "_concrete_slab", "slab", Blocks.WHITE_CONCRETE, color, blockLux, "concrete_slab");
            BlockCreator.createWoodSet(dye + "_stained", color, blockLux, "dyed_wood");
            BlockCreator.generateBrickSet(dye + "_brick", Blocks.BRICKS, color, blockLux, "dyed_bricks");
            if (!VANILLA_DYE) {
                BlockCreator.createPyriteBlock(dye + "_terracotta", "block", Blocks.TERRACOTTA, color, blockLux, "terracotta");
            }
            BlockCreator.generateBrickSet(dye + "_terracotta_brick", Blocks.TERRACOTTA, color, blockLux, "terracotta_bricks");
            BlockCreator.createTorch(dye + "_torch", ModHelpers.getTorchParticle(dye));
            if (!VANILLA_DYE) {
                BlockCreator.createPyriteBlock(dye + "_stained_glass", "stained_framed_glass", Float.valueOf(0.3f), color, blockLux, "stained_glass");
                BlockCreator.createPyriteBlock(dye + "_stained_glass_pane", "stained_framed_glass_pane", Float.valueOf(0.3f), color, blockLux, "stained_glass_pane");
            }
            BlockCreator.createPyriteBlock(dye + "_lamp", "lamp", Float.valueOf(0.3f), color, 15, "lamp");
            BlockCreator.createPyriteBlock(dye + "_framed_glass", "stained_framed_glass", Float.valueOf(2.0f), color, blockLux, "framed_glass");
            BlockCreator.createPyriteBlock(dye + "_framed_glass_pane", "stained_framed_glass_pane", Float.valueOf(2.0f), color, blockLux, "framed_glass_pane");
            BlockCreator.createTorchLever(dye + "_torch_lever", Blocks.TORCH, ModHelpers.getTorchParticle(dye));
        }
        for (Block wallsBlock : ModLists.getVanillaWalls()) {
            Object block = ModHelpers.findVanillaBlockID(wallsBlock);
            if (!((String)block).contains("wall")) {
                block = (String)block + "_wall";
            }
            BlockCreator.createPyriteBlock((String)block + "_gate", "wall_gate", wallsBlock, BlockSetType.STONE, "building_blocks");
        }
    }
}

