/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModTorch
extends FaceAttachedHorizontalDirectionalBlock {
    private final ParticleOptions particle;
    private static final Map<Direction, VoxelShape> WALL_BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
            case AttachFace.WALL -> ModTorch.getBoundingShape(state);
            default -> Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        };
    }

    public ModTorch(BlockBehaviour.Properties settings, ParticleOptions particle) {
        super(settings);
        this.particle = particle;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACE, FACING});
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double yPlus;
        double xPlus;
        double zPlus = switch ((AttachFace)state.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> {
                xPlus = (double)pos.getX() + 0.5;
                yPlus = (double)pos.getY() + 0.65;
                yield (double)pos.getZ() + 0.5;
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: {
                        xPlus = (double)pos.getX() + 0.3;
                        yPlus = (double)pos.getY() + 0.9;
                        yield (double)pos.getZ() + 0.5;
                    }
                    case WEST: {
                        xPlus = (double)pos.getX() + 0.7;
                        yPlus = (double)pos.getY() + 0.9;
                        yield (double)pos.getZ() + 0.5;
                    }
                    case SOUTH: {
                        xPlus = (double)pos.getX() + 0.5;
                        yPlus = (double)pos.getY() + 0.9;
                        yield (double)pos.getZ() + 0.25;
                    }
                }
                xPlus = (double)pos.getX() + 0.5;
                yPlus = (double)pos.getY() + 0.9;
                yield (double)pos.getZ() + 0.8;
            }
            default -> {
                xPlus = (double)pos.getX() + 0.5;
                yPlus = (double)pos.getY() + 0.4;
                yield (double)pos.getZ() + 0.5;
            }
        };
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, xPlus, yPlus, zPlus, 0.0, 0.0, 0.0);
        world.addParticle(this.particle, xPlus, yPlus, zPlus, 0.0, 0.0, 0.0);
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return ModTorch.canPlaceAt(world, pos, ModTorch.getConnectedDirection((BlockState)state).getOpposite());
    }

    public static boolean canPlaceAt(LevelReader world, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite()) | ModTorch.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return WALL_BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }
}

