/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.Nullable;

public class SwitchableGlass
extends TransparentBlock {
    public static final MapCodec<SwitchableGlass> CODEC = SwitchableGlass.simpleCodec(SwitchableGlass::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<SwitchableGlass> codec() {
        return CODEC;
    }

    public SwitchableGlass(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 0.0f;
        }
        return 1.0f;
    }

    protected int getOpacity(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(ctx.getLevel().hasNeighborSignal(ctx.getClickedPos())));
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        boolean currentlyPowered;
        if (!world.isClientSide() && (currentlyPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != world.hasNeighborSignal(pos)) {
            if (currentlyPowered) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }
}

