/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.functions;

import cc.cassian.pyrite.Pyrite;
import cc.cassian.pyrite.functions.neoforge.ModHelpersImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.PowerParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class ModHelpers {
    public static BlockBehaviour.Properties copyBlock(Block copyBlock) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)copyBlock);
    }

    public static ToIntFunction<BlockState> parseLux(int lux) {
        return state -> lux;
    }

    public static String findVanillaBlockID(Block block) {
        return block.toString().substring(block.toString().indexOf(":") + 1, block.toString().indexOf("}"));
    }

    public static ResourceLocation locate(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"pyrite", (String)id);
    }

    public static ResourceKey<Block> registryKeyBlock(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ModHelpers.locate(id));
    }

    public static ResourceKey<Item> registryKeyItem(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ModHelpers.locate(id));
    }

    public static Item.Properties newItemSettings(String id) {
        return new Item.Properties().setId(ModHelpers.registryKeyItem(id));
    }

    public static Item.Properties newBlockItemSettings(String id) {
        return ModHelpers.newItemSettings(id).useBlockDescriptionPrefix();
    }

    public static Block getBlock(String id) {
        return (Block)BuiltInRegistries.BLOCK.getValue(ModHelpers.locate(id));
    }

    public static MapColor checkDyeMapColour(String dye) {
        return switch (dye) {
            case "glow" -> MapColor.COLOR_CYAN;
            case "dragon" -> MapColor.COLOR_BLACK;
            case "star" -> MapColor.QUARTZ;
            case "honey" -> MapColor.COLOR_YELLOW;
            case "nostalgia" -> MapColor.COLOR_BROWN;
            case "rose" -> MapColor.FIRE;
            case "poisonous" -> MapColor.COLOR_LIGHT_GREEN;
            default -> DyeColor.valueOf((String)dye.toUpperCase()).getMapColor();
        };
    }

    public static int checkDyeLux(String dye) {
        return switch (dye) {
            case "glow" -> 8;
            case "star" -> 15;
            default -> 0;
        };
    }

    public static ParticleOptions getTorchParticle(String dye) {
        return switch (dye) {
            case "dragon" -> PowerParticleOption.create((ParticleType)ParticleTypes.DRAGON_BREATH, (float)1.0f);
            case "glow" -> ParticleTypes.GLOW;
            case "star" -> ParticleTypes.ENCHANT;
            default -> ParticleTypes.SMOKE;
        };
    }

    public static int power(String blockID) {
        if (blockID.contains("redstone")) {
            return 15;
        }
        return 0;
    }

    public static DyeColor getDyeColorFromFramedId(String blockID) {
        String dye = blockID.contains("framed") ? blockID.split("_framed")[0] : (blockID.contains("stained") ? blockID.split("_stained")[0] : "");
        return switch (dye) {
            case "glow" -> DyeColor.CYAN;
            case "dragon" -> DyeColor.BLACK;
            case "star" -> DyeColor.LIGHT_BLUE;
            case "honey" -> DyeColor.YELLOW;
            case "nostalgia" -> DyeColor.BROWN;
            case "rose" -> DyeColor.PINK;
            case "poisonous" -> DyeColor.LIME;
            default -> DyeColor.byName((String)dye, (DyeColor)DyeColor.WHITE);
        };
    }

    @NotNull
    public static BlockSetType getBlockSetType(String blockID) {
        boolean openByHand = !blockID.equals("emerald") && !blockID.equals("netherite") && !blockID.equals("diamond");
        SoundType soundGroup = switch (blockID) {
            case "amethyst" -> SoundType.AMETHYST;
            case "copper", "exposed_copper", "weathered_copper", "oxidized_copper" -> SoundType.COPPER;
            case "quartz", "lapis", "diamond", "redstone", "gold" -> SoundType.STONE;
            default -> SoundType.METAL;
        };
        return new BlockSetType(blockID, openByHand, openByHand, openByHand, BlockSetType.PressurePlateSensitivity.EVERYTHING, soundGroup, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.METAL_PRESSURE_PLATE_CLICK_OFF, SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modID) {
        return ModHelpersImpl.isModLoaded(modID);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isShield(ItemStack stack) {
        return ModHelpersImpl.isShield(stack);
    }

    public static boolean isCopper(String blockID) {
        return blockID.contains("copper");
    }

    public static WeatheringCopper.WeatherState getOxidizationState(String blockID) {
        if (blockID.contains("oxidized")) {
            return WeatheringCopper.WeatherState.OXIDIZED;
        }
        if (blockID.contains("weathered")) {
            return WeatheringCopper.WeatherState.WEATHERED;
        }
        if (blockID.contains("exposed")) {
            return WeatheringCopper.WeatherState.EXPOSED;
        }
        return WeatheringCopper.WeatherState.UNAFFECTED;
    }

    public static void log(String log) {
        if (ModHelpers.isDevEnvironment()) {
            Pyrite.LOGGER.info(log);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevEnvironment() {
        return ModHelpersImpl.isDevEnvironment();
    }
}

