/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.registry;

import cc.cassian.pyrite.functions.ModHelpers;
import cc.cassian.pyrite.functions.ModLists;
import cc.cassian.pyrite.registry.neoforge.BlockCreatorImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class BlockCreator {
    static final Block[] vanillaWood = ModLists.getVanillaWood();
    static final Block[] resource_blocks = ModLists.getVanillaResourceBlocks();

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformRegister(String blockID, String blockType, BlockBehaviour.Properties blockSettings, WoodType woodType, BlockSetType blockSetType, ParticleOptions particle, Block copyBlock, String group, MapColor color) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        BlockCreatorImpl.platformRegister(blockID, (String)var1_1, (BlockBehaviour.Properties)var2_2, (WoodType)var3_3, (BlockSetType)var4_4, (ParticleOptions)var5_5, (Block)var6_6, (String)var7_7, (MapColor)var8_8);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPyriteItem(String itemID) {
        BlockCreatorImpl.registerPyriteItem(itemID);
    }

    public static void generateResourceBlocks() {
        for (Block resourceBlock : resource_blocks) {
            String block = ModHelpers.findVanillaBlockID(resourceBlock);
            if (block.contains("block")) {
                block = block.substring(0, block.indexOf("_block"));
            }
            BlockCreator.createResourceBlockSet(block, resourceBlock);
        }
    }

    public static void createTorchLever(String blockID, Block baseTorch, ParticleOptions particle) {
        BlockCreator.sendToRegistry(blockID, "torch_lever", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseTorch), particle, "torch_lever");
    }

    public static void createTorch(String blockID, ParticleOptions particle) {
        BlockCreator.sendToRegistry(blockID, "torch", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH), particle, "torch");
    }

    public static void generateVanillaCraftingTables() {
        for (Block plankBlock : vanillaWood) {
            String block = ModHelpers.findVanillaBlockID(plankBlock);
            if (block.contains("planks")) {
                block = block.substring(0, block.indexOf("_planks"));
            }
            BlockCreator.createPyriteBlock(block + "_crafting_table", "crafting", plankBlock, "crafting_table");
        }
    }

    public static void createPyriteBlock(String blockID, String blockType, Float strength, MapColor color, int lightLevel, String group) {
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.of().strength(strength.floatValue()).lightLevel(state -> lightLevel).mapColor(color);
        if (Objects.equals(blockType, "obsidian")) {
            BlockCreator.sendToRegistry(blockID, "block", settings.strength(strength.floatValue(), 1200.0f).pushReaction(PushReaction.BLOCK), group);
        } else if (blockType.equals("lamp")) {
            BlockCreator.sendToRegistry(blockID, blockType, settings.sound(SoundType.GLASS), group);
        } else {
            BlockCreator.sendToRegistry(blockID, blockType, settings.sound(SoundType.GLASS).noOcclusion().isRedstoneConductor(BlockCreator::never), group);
        }
    }

    private static boolean never(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    private static void createCarpet(String blockID, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(Blocks.MOSS_CARPET);
        BlockCreator.sendToRegistry(blockID, "carpet", blockSettings, group);
    }

    public static void createPyriteBlock(String blockID, String blockType, Block copyBlock, String group) {
        BlockCreator.platformRegister(blockID, blockType, ModHelpers.copyBlock(copyBlock), WoodType.CRIMSON, BlockSetType.IRON, null, copyBlock, group, null);
    }

    public static void createStair(String blockID, Block copyBlock, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(copyBlock);
        BlockCreator.sendToRegistry(blockID + "_stairs", copyBlock, blockSettings, group);
    }

    public static void createSlab(String blockID, Block copyBlock, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(copyBlock);
        BlockCreator.sendToRegistry(blockID + "_slab", "slab", blockSettings, group);
    }

    public static void createPyriteBlock(String blockID, String blockType, Block copyBlock, int lux, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(copyBlock).lightLevel(ModHelpers.parseLux(lux));
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, null, copyBlock, group, null);
    }

    private static void sendToRegistry(String blockID, String blockType, BlockBehaviour.Properties blockSettings, String group) {
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, null, null, group, null);
    }

    private static void sendToRegistry(String blockID, Block copyBlock, BlockBehaviour.Properties blockSettings, String group) {
        BlockCreator.platformRegister(blockID, "stairs", blockSettings, null, null, null, copyBlock, group, null);
    }

    private static void sendToRegistry(String blockID, String blockType, BlockBehaviour.Properties blockSettings, ParticleOptions particle, String group) {
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, particle, null, group, null);
    }

    public static void createPyriteBlock(String blockID, String blockType, Block copyBlock, BlockSetType set, String group) {
        BlockCreator.platformRegister(blockID, blockType, ModHelpers.copyBlock(copyBlock), null, set, null, copyBlock, group, null);
    }

    public static void createPyriteBlock(String blockID, String blockType, Block copyBlock, MapColor color, int lux, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(copyBlock).mapColor(color).lightLevel(ModHelpers.parseLux(lux));
        if (copyBlock.equals(Blocks.OAK_PLANKS) || copyBlock.equals(Blocks.OAK_SLAB) || copyBlock.equals(Blocks.OAK_STAIRS)) {
            blockSettings = blockSettings.ignitedByLava();
        }
        BlockCreator.platformRegister(blockID, blockType, blockSettings, null, null, null, copyBlock, group, color);
    }

    public static void createPyriteBlock(String blockID, Block copyBlock, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(copyBlock);
        BlockCreator.platformRegister(blockID, "block", blockSettings, null, null, null, null, group, null);
    }

    public static void createPyriteBlock(String blockID, String blockType, Block copyBlock, MapColor color, int lux, BlockSetType set, WoodType type, String group) {
        BlockBehaviour.Properties blockSettings = ModHelpers.copyBlock(copyBlock).mapColor(color).lightLevel(ModHelpers.parseLux(lux));
        if (!blockType.equals("button")) {
            blockSettings = blockSettings.ignitedByLava();
        }
        BlockCreator.platformRegister(blockID, blockType, blockSettings, type, set, null, null, group, color);
    }

    public static void generateFlowers() {
        for (Map.Entry<String, Block> entry : ModLists.FLOWERS.entrySet()) {
            BlockCreator.createPyriteBlock(entry.getKey(), "flower", entry.getValue(), "flower");
        }
    }

    public static void generateTurfSets() {
        for (Map.Entry<String, Block> entry : ModLists.TURF_SETS.entrySet()) {
            BlockCreator.createTurfSet(entry.getKey(), entry.getValue());
        }
    }

    public static void generateNostalgiaBlocks() {
        for (Map.Entry<String, Block> entry : ModLists.NOSTALGIA_BLOCKS.entrySet()) {
            BlockCreator.createPyriteBlock(entry.getKey(), "block", entry.getValue(), entry.getKey());
        }
        BlockCreator.createPyriteBlock("nostalgia_gravel", "gravel", Blocks.GRAVEL, "gravel");
    }

    public static void generateBrickSet(String blockID, Block copyBlock, MapColor color, int lux, @Nullable String group) {
        if (group == null) {
            group = blockID;
        }
        BlockCreator.createPyriteBlock(blockID + "s", "block", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_stairs", "stairs", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_slab", "slab", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_wall", "wall", copyBlock, color, lux, group);
        BlockCreator.createPyriteBlock(blockID + "_wall_gate", "wall_gate", copyBlock, BlockSetType.STONE, group);
    }

    public static void generateBrickSet(String blockID, Block copyBlock, MapColor color) {
        BlockCreator.generateBrickSet(blockID, copyBlock, color, 0, blockID);
    }

    public static void generateBrickSet(String blockID, Block copyBlock) {
        BlockCreator.generateBrickSet(blockID, copyBlock, copyBlock.defaultMapColor());
    }

    public static void generateBrickSet(String blockID, Block copyBlock, MapColor color, boolean generateMossySet, String group) {
        BlockCreator.generateBrickSet(blockID, copyBlock, color, 0, group);
        if (generateMossySet) {
            BlockCreator.generateBrickSet("mossy_" + blockID, copyBlock, color, 0, null);
        }
    }

    public static void generateBrickSet(String blockID, Block copyBlock, MapColor color, boolean generateMossySet) {
        BlockCreator.generateBrickSet(blockID, copyBlock, color, generateMossySet, blockID);
    }

    public static void createTurfSet(String blockID, Block copyBlock) {
        BlockCreator.createPyriteBlock(blockID + "_turf", "block", copyBlock, blockID);
        BlockCreator.createStair(blockID, copyBlock, blockID);
        BlockCreator.createSlab(blockID, copyBlock, blockID);
        BlockCreator.createCarpet(blockID + "_carpet", blockID);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static WoodType createWoodType(String blockID, BlockSetType setType) {
        void var1_1;
        return BlockCreatorImpl.createWoodType(blockID, (BlockSetType)var1_1);
    }

    public static void createWoodSet(String blockID, MapColor color, int blockLux, String group) {
        BlockSetType GENERATED_SET = new BlockSetType(blockID);
        WoodType GENERATED_TYPE = BlockCreator.createWoodType(blockID, GENERATED_SET);
        BlockCreator.createPyriteBlock("%s_planks".formatted(blockID), "block", Blocks.OAK_PLANKS, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_stairs".formatted(blockID), "stairs", Blocks.OAK_STAIRS, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_slab".formatted(blockID), "slab", Blocks.OAK_SLAB, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_fence".formatted(blockID), "fence", Blocks.OAK_FENCE, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_fence_gate".formatted(blockID), "fence_gate", Blocks.OAK_FENCE_GATE, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_door".formatted(blockID), "door", Blocks.OAK_DOOR, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_trapdoor".formatted(blockID), "trapdoor", Blocks.OAK_TRAPDOOR, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_pressure_plate".formatted(blockID), "pressure_plate", Blocks.OAK_PRESSURE_PLATE, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_button".formatted(blockID), "button", Blocks.OAK_BUTTON, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_crafting_table".formatted(blockID), "crafting", Blocks.CRAFTING_TABLE, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_ladder".formatted(blockID), "ladder", Blocks.LADDER, color, blockLux, group);
        BlockCreator.createPyriteBlock("%s_sign".formatted(blockID), "sign", Blocks.OAK_SIGN, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_hanging_sign".formatted(blockID), "hanging_sign", Blocks.OAK_HANGING_SIGN, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
        BlockCreator.createPyriteBlock("%s_chest".formatted(blockID), "chest", Blocks.CHEST, color, blockLux, GENERATED_SET, GENERATED_TYPE, group);
    }

    public static void createWoodSetWithLog(String blockID, MapColor color, int blockLux) {
        BlockCreator.createPyriteBlock("%s_log".formatted(blockID), "log", Blocks.OAK_LOG, color, blockLux, "wood");
        BlockCreator.createPyriteBlock("stripped_%s_log".formatted(blockID), "log", Blocks.STRIPPED_OAK_LOG, color, blockLux, "wood");
        BlockCreator.createPyriteBlock("%s_wood".formatted(blockID), "wood", Blocks.OAK_WOOD, color, blockLux, "wood");
        BlockCreator.createPyriteBlock("stripped_%s_wood".formatted(blockID), "wood", Blocks.STRIPPED_OAK_WOOD, color, blockLux, "wood");
        BlockCreator.createWoodSet(blockID, color, blockLux, "wood");
    }

    public static void createCutBlocks(String blockID, Block block) {
        String cutBlockID = "cut_" + blockID;
        if (!blockID.contains("copper")) {
            BlockCreator.createPyriteBlock(cutBlockID, block, blockID);
            BlockCreator.createStair(cutBlockID, block, blockID);
            BlockCreator.createSlab(cutBlockID, block, blockID);
        }
        BlockCreator.createPyriteBlock("%s_wall".formatted(cutBlockID), "wall", block, blockID);
        BlockCreator.createPyriteBlock("%s_wall_gate".formatted(cutBlockID), "wall_gate", block, blockID);
    }

    public static void createSmoothBlocks(String blockID, Block block) {
        String smoothBlockID = "smooth_" + blockID;
        if (!Objects.equals(blockID, "quartz")) {
            BlockCreator.createPyriteBlock(smoothBlockID, block, blockID);
            BlockCreator.createStair(smoothBlockID, block, blockID);
            BlockCreator.createSlab(smoothBlockID, block, blockID);
        }
        BlockCreator.createPyriteBlock("%s_wall".formatted(smoothBlockID), "wall", block, blockID);
        BlockCreator.createPyriteBlock("%s_wall_gate".formatted(smoothBlockID), "wall_gate", block, blockID);
    }

    public static void createResourceBlockSet(String blockID, Block block) {
        BlockCreator.createCutBlocks(blockID, block);
        if (!Objects.equals(blockID, "quartz")) {
            BlockCreator.createPyriteBlock("%s_bricks".formatted(blockID), block, blockID);
            if (!blockID.contains("copper")) {
                BlockCreator.createPyriteBlock("chiseled_%s_block".formatted(blockID), "log", block, blockID);
            }
            BlockCreator.createPyriteBlock("%s_pillar".formatted(blockID), "log", block, blockID);
        }
        BlockCreator.createSmoothBlocks(blockID, block);
        BlockCreator.createPyriteBlock("nostalgia_%s_block".formatted(blockID), block, blockID);
        BlockSetType set = ModHelpers.getBlockSetType(blockID);
        if (!blockID.equals("iron")) {
            if (!blockID.contains("copper")) {
                BlockCreator.createPyriteBlock("%s_bars".formatted(blockID), "bars", block, blockID);
                BlockCreator.createPyriteBlock("%s_door".formatted(blockID), "door", block, set, blockID);
                BlockCreator.createPyriteBlock("%s_trapdoor".formatted(blockID), "trapdoor", block, set, blockID);
            }
            if (!blockID.equals("gold")) {
                BlockCreator.createPyriteBlock("%s_pressure_plate".formatted(blockID), "pressure_plate", block, set, blockID);
            }
        }
        BlockCreator.createPyriteBlock("%s_button".formatted(blockID), "button", block, set, blockID);
    }
}

