/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.registry.neoforge;

import cc.cassian.pyrite.blocks.GravelBlock;
import cc.cassian.pyrite.blocks.ModBlock;
import cc.cassian.pyrite.blocks.ModCarpet;
import cc.cassian.pyrite.blocks.ModCraftingTable;
import cc.cassian.pyrite.blocks.ModFacingBlock;
import cc.cassian.pyrite.blocks.ModGlass;
import cc.cassian.pyrite.blocks.ModPane;
import cc.cassian.pyrite.blocks.ModPillar;
import cc.cassian.pyrite.blocks.ModPressurePlate;
import cc.cassian.pyrite.blocks.ModSlab;
import cc.cassian.pyrite.blocks.ModStairs;
import cc.cassian.pyrite.blocks.ModTorch;
import cc.cassian.pyrite.blocks.ModWall;
import cc.cassian.pyrite.blocks.ModWood;
import cc.cassian.pyrite.blocks.ModWoodenButton;
import cc.cassian.pyrite.blocks.OxidizableBarsBlock;
import cc.cassian.pyrite.blocks.OxidizablePillarBlock;
import cc.cassian.pyrite.blocks.OxidizableWallBlock;
import cc.cassian.pyrite.blocks.OxidizableWallGateBlock;
import cc.cassian.pyrite.blocks.StainedFramedGlass;
import cc.cassian.pyrite.blocks.SwitchableGlass;
import cc.cassian.pyrite.blocks.TorchLever;
import cc.cassian.pyrite.blocks.WallGateBlock;
import cc.cassian.pyrite.compat.ChestsCompat;
import cc.cassian.pyrite.functions.ModHelpers;
import cc.cassian.pyrite.functions.ModLists;
import cc.cassian.pyrite.functions.neoforge.NeoHelpers;
import cc.cassian.pyrite.registry.PyriteItemGroups;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockCreatorImpl {
    public static Supplier<Block> WOOD_ICON;
    public static Supplier<Block> RESOURCE_ICON;
    public static Supplier<Block> BRICK_ICON;
    public static Supplier<Block> MISC_ICON;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<CreativeModeTab> TABS;
    public static final ArrayList<Supplier<Item>> ALL_ITEMS;
    public static final ArrayList<Supplier<Block>> SIGN_BLOCKS;
    public static final ArrayList<Supplier<Block>> HANGING_SIGN_BLOCKS;
    public static final ArrayList<Supplier<?>> WOOD_BLOCKS;
    public static final ArrayList<Supplier<?>> RESOURCE_BLOCKS;
    public static final ArrayList<Supplier<?>> BRICK_BLOCKS;
    public static final ArrayList<Supplier<Block>> REDSTONE_BLOCKS;
    public static final ArrayList<Supplier<?>> MISC_BLOCKS;

    public static WoodType createWoodType(String blockID, BlockSetType setType) {
        WoodType woodType = new WoodType(ModHelpers.locate(blockID).toString(), setType);
        WoodType.register((WoodType)woodType);
        return woodType;
    }

    public static void platformRegister(String blockID, String blockType, BlockBehaviour.Properties settings, WoodType woodType, BlockSetType blockSetType, ParticleOptions particle, Block copyBlock, String group, MapColor color) {
        int power = blockID.contains("redstone") ? 15 : 0;
        Object newBlock = null;
        BlockBehaviour.Properties blockSettings = settings.setId(ModHelpers.registryKeyBlock(blockID));
        switch (blockType.toLowerCase()) {
            case "block": 
            case "lamp": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new WeatheringCopperFullBlock(ModHelpers.getOxidizationState(blockID), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new ModBlock(blockSettings), "waxed_" + group);
                    break;
                }
                newBlock = BLOCKS.register(blockID, () -> new ModBlock(blockSettings, power));
                if (power == 15) {
                    if (blockID.equals("lit_redstone_lamp")) {
                        REDSTONE_BLOCKS.addFirst((Supplier<Block>)newBlock);
                    } else {
                        REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                    }
                }
                if (!Objects.equals(copyBlock, Blocks.OAK_PLANKS)) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "crafting": {
                BlockBehaviour.Properties craftingSettings = !blockID.contains("crimson") && !blockID.contains("warped") ? blockSettings.ignitedByLava() : blockSettings;
                newBlock = BLOCKS.register(blockID, () -> new ModCraftingTable(craftingSettings));
                if (!blockID.contains("crimson") && !blockID.contains("warped")) {
                    NeoHelpers.FUEL_BLOCKS.put((Supplier<Block>)newBlock, 300);
                }
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "chest": {
                if (!ModList.get().isLoaded("lolmcv")) break;
                newBlock = ChestsCompat.registerChest(blockID, blockSettings, group, copyBlock, color);
                ChestsCompat.add((Supplier<Block>)newBlock);
                break;
            }
            case "ladder": {
                newBlock = BLOCKS.register(blockID, () -> new LadderBlock(blockSettings));
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "carpet": {
                newBlock = BLOCKS.register(blockID, () -> new ModCarpet(blockSettings));
                break;
            }
            case "slab": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new WeatheringCopperSlabBlock(ModHelpers.getOxidizationState(blockID), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new ModSlab(blockSettings), "waxed_" + group);
                } else {
                    newBlock = BLOCKS.register(blockID, () -> new ModSlab(blockSettings, power));
                }
                if (Objects.equals(copyBlock, Blocks.OAK_SLAB)) {
                    WOOD_BLOCKS.add((Supplier<?>)newBlock);
                }
                if (power != 15) break;
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "stairs": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new WeatheringCopperStairBlock(ModHelpers.getOxidizationState(blockID), copyBlock.defaultBlockState(), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new ModStairs(copyBlock.defaultBlockState(), blockSettings), "waxed_" + group);
                } else {
                    newBlock = BLOCKS.register(blockID, () -> new ModStairs(copyBlock.defaultBlockState(), blockSettings));
                }
                if (!Objects.equals(copyBlock, Blocks.OAK_STAIRS)) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "wall": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new OxidizableWallBlock(ModHelpers.getOxidizationState(blockID), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new ModWall(blockSettings), "waxed_" + group);
                    break;
                }
                newBlock = BLOCKS.register(blockID, () -> new ModWall(blockSettings, power));
                if (power != 15) break;
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "fence": {
                newBlock = BLOCKS.register(blockID, () -> new FenceBlock(blockSettings));
                if (power != 15) break;
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "log": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new OxidizablePillarBlock(ModHelpers.getOxidizationState(blockID), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new ModPillar(blockSettings), "waxed_" + group);
                    break;
                }
                newBlock = BLOCKS.register(blockID, () -> new ModPillar(blockSettings, power));
                if (blockID.contains("mushroom") || blockID.contains("log")) {
                    WOOD_BLOCKS.add((Supplier<?>)newBlock);
                    break;
                }
                if (power != 15) break;
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "wood": {
                newBlock = BLOCKS.register(blockID, () -> new ModWood(blockSettings));
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "facing": {
                newBlock = BLOCKS.register(blockID, () -> new ModFacingBlock(blockSettings, power));
                if (power != 15) break;
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "bars": 
            case "glass_pane": 
            case "tinted_glass_pane": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new OxidizableBarsBlock(ModHelpers.getOxidizationState(blockID), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new ModPane(blockSettings), "waxed_" + group);
                    break;
                }
                newBlock = BLOCKS.register(blockID, () -> new ModPane(blockSettings, power));
                if (power != 15) break;
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "stained_framed_glass_pane": {
                newBlock = BLOCKS.register(blockID, () -> new StainedGlassPaneBlock(ModHelpers.getDyeColorFromFramedId(blockID), blockSettings));
                break;
            }
            case "glass": 
            case "tinted_glass": {
                newBlock = BLOCKS.register(blockID, () -> new ModGlass(blockSettings));
                break;
            }
            case "stained_framed_glass": {
                newBlock = BLOCKS.register(blockID, () -> new StainedFramedGlass(ModHelpers.getDyeColorFromFramedId(blockID), blockSettings));
                break;
            }
            case "gravel": {
                newBlock = BLOCKS.register(blockID, () -> new GravelBlock(blockSettings));
                break;
            }
            case "flower": {
                DeferredHolder finalNewBlock = newBlock = BLOCKS.register(blockID, () -> new FlowerBlock(MobEffects.NIGHT_VISION, 5.0f, blockSettings));
                DeferredHolder pot = BLOCKS.register("potted_" + blockID, () -> BlockCreatorImpl.lambda$platformRegister$30((Supplier)finalNewBlock, blockID));
                PyriteItemGroups.POTTED_FLOWERS.put(blockID, (Supplier<FlowerPotBlock>)pot);
                break;
            }
            case "fence_gate": {
                newBlock = BLOCKS.register(blockID, () -> new FenceGateBlock(woodType, blockSettings));
                if (!blockID.contains("_stained") && !blockID.contains("mushroom")) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "wall_gate": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = BLOCKS.register(blockID, () -> new OxidizableWallGateBlock(ModHelpers.getOxidizationState(blockID), blockSettings));
                    BlockCreatorImpl.registerBlock("waxed_" + blockID, () -> new WallGateBlock(blockSettings), "waxed_" + group);
                    break;
                }
                newBlock = BLOCKS.register(blockID, () -> new WallGateBlock(blockSettings));
                break;
            }
            case "sign": {
                newBlock = BLOCKS.register(blockID, () -> new StandingSignBlock(woodType, blockSettings));
                DeferredHolder wallSign = BLOCKS.register(blockID.replace("_sign", "_wall_sign"), () -> new WallSignBlock(woodType, blockSettings));
                SIGN_BLOCKS.add((Supplier<Block>)newBlock);
                SIGN_BLOCKS.add((Supplier<Block>)wallSign);
                BlockCreatorImpl.registerSignItem((Supplier<Block>)newBlock, (Supplier<Block>)wallSign, blockID);
                break;
            }
            case "hanging_sign": {
                newBlock = BLOCKS.register(blockID, () -> new CeilingHangingSignBlock(woodType, blockSettings));
                DeferredHolder hangingWallSign = BLOCKS.register(blockID.replace("_sign", "_wall_sign"), () -> new WallHangingSignBlock(woodType, blockSettings));
                HANGING_SIGN_BLOCKS.add((Supplier<Block>)newBlock);
                HANGING_SIGN_BLOCKS.add((Supplier<Block>)hangingWallSign);
                BlockCreatorImpl.registerHangingSignItem((Supplier<Block>)newBlock, (Supplier<Block>)hangingWallSign, blockID);
                break;
            }
            case "door": {
                newBlock = BLOCKS.register(blockID, () -> new DoorBlock(blockSetType, blockSettings.noOcclusion()));
                if (!blockID.contains("_stained") && !blockID.contains("mushroom")) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "trapdoor": {
                newBlock = BLOCKS.register(blockID, () -> new TrapDoorBlock(blockSetType, blockSettings.noOcclusion()));
                if (!blockID.contains("_stained") && !blockID.contains("mushroom")) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "button": {
                newBlock = BLOCKS.register(blockID, () -> new ModWoodenButton(blockSettings, blockSetType));
                if (!blockID.contains("_stained") && !blockID.contains("mushroom")) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "pressure_plate": {
                newBlock = BLOCKS.register(blockID, () -> new ModPressurePlate(blockSettings, blockSetType));
                if (!blockID.contains("_stained") && !blockID.contains("mushroom")) break;
                WOOD_BLOCKS.add((Supplier<?>)newBlock);
                break;
            }
            case "torch": {
                if (particle == null) {
                    newBlock = BLOCKS.register(blockID, () -> new ModTorch(blockSettings.noOcclusion(), (ParticleOptions)ParticleTypes.FLAME));
                    break;
                }
                newBlock = BLOCKS.register(blockID, () -> new ModTorch(blockSettings.noOcclusion(), particle));
                break;
            }
            case "torch_lever": {
                newBlock = BLOCKS.register(blockID, () -> new TorchLever(blockSettings.noOcclusion(), particle));
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            case "concrete_powder": {
                newBlock = BLOCKS.register(blockID, () -> new ConcretePowderBlock(ModHelpers.getBlock(blockID.replace("_powder", "")), blockSettings));
                break;
            }
            case "switchable_glass": {
                newBlock = BLOCKS.register(blockID, () -> new SwitchableGlass(blockSettings));
                REDSTONE_BLOCKS.add((Supplier<Block>)newBlock);
                break;
            }
            default: {
                ModHelpers.log("%s created as a generic block, block provided: %s".formatted(blockID, blockType));
                newBlock = BLOCKS.register(blockID, () -> new Block(blockSettings));
            }
        }
        if (newBlock == null) {
            return;
        }
        for (Block block : ModLists.getVanillaResourceBlocks()) {
            if (!blockID.contains(BuiltInRegistries.BLOCK.getKey((Object)block).getPath().replace("_block", "")) || BlockCreatorImpl.inGroup(newBlock)) continue;
            RESOURCE_BLOCKS.add((Supplier<?>)newBlock);
        }
        if (blockID.contains("brick") && !BlockCreatorImpl.inGroup(newBlock)) {
            BRICK_BLOCKS.add((Supplier<?>)newBlock);
        }
        if (blockID.equals("dragon_stained_crafting_table")) {
            WOOD_ICON = newBlock;
        } else if (blockID.equals("cut_emerald")) {
            RESOURCE_ICON = newBlock;
        } else if (blockID.equals("cobblestone_bricks")) {
            BRICK_ICON = newBlock;
        } else if (blockID.equals("glowing_obsidian")) {
            MISC_ICON = newBlock;
        } else if (blockID.contains("grass")) {
            NeoHelpers.addGrassBlock((Supplier<Block>)newBlock);
        }
        if (!blockType.equals("sign") && !blockType.equals("hanging_sign")) {
            BlockCreatorImpl.registerBlockItem(blockID, (Supplier<Block>)newBlock);
            if (!BlockCreatorImpl.inGroup(newBlock)) {
                MISC_BLOCKS.add((Supplier<?>)newBlock);
            }
        }
        PyriteItemGroups.match((Supplier<Block>)newBlock, copyBlock, group, blockID);
    }

    public static void registerBlock(String blockID, Supplier<Block> block, String group) {
        DeferredHolder newBlock = BLOCKS.register(blockID, block);
        BlockCreatorImpl.registerBlockItem(blockID, (Supplier<Block>)newBlock);
        PyriteItemGroups.match((Supplier<Block>)newBlock, null, group, blockID);
    }

    public static void registerBlockItem(String blockID, Supplier<Block> newBlock) {
        Item.Properties settings = ModHelpers.newBlockItemSettings(blockID);
        if (blockID.contains("netherite")) {
            settings = settings.fireResistant();
        }
        Item.Properties finalSettings = settings;
        ALL_ITEMS.add((Supplier<Item>)ITEMS.register(blockID, () -> new BlockItem((Block)newBlock.get(), finalSettings)));
    }

    public static void registerSignItem(Supplier<Block> newBlock, Supplier<Block> wallSign, String blockID) {
        DeferredHolder newItem = ITEMS.register(blockID, () -> new SignItem((Block)newBlock.get(), (Block)wallSign.get(), ModHelpers.newItemSettings(blockID).stacksTo(16)));
        ALL_ITEMS.add((Supplier<Item>)newItem);
        WOOD_BLOCKS.add((Supplier<?>)newItem);
    }

    public static void registerHangingSignItem(Supplier<Block> newBlock, Supplier<Block> wallSign, String blockID) {
        DeferredHolder newItem = ITEMS.register(blockID, () -> new HangingSignItem((Block)newBlock.get(), (Block)wallSign.get(), ModHelpers.newItemSettings(blockID).stacksTo(16)));
        ALL_ITEMS.add((Supplier<Item>)newItem);
        WOOD_BLOCKS.add((Supplier<?>)newItem);
    }

    public static boolean inGroup(Object obj) {
        return WOOD_BLOCKS.contains(obj) || BRICK_BLOCKS.contains(obj) || RESOURCE_BLOCKS.contains(obj) || REDSTONE_BLOCKS.contains(obj) || MISC_BLOCKS.contains(obj);
    }

    public static void addItemGroup(String id, Supplier<Block> icon, ArrayList<Supplier<?>> blocks) {
        DeferredHolder PYRITE_GROUP = TABS.register(id, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup.pyrite." + id))).icon(() -> BlockCreatorImpl.lambda$addItemGroup$52((Supplier)icon)).displayItems((params, entries) -> {
            for (Supplier obj : blocks) {
                Object patt0$temp = obj.get();
                if (patt0$temp instanceof Block) {
                    Block block = (Block)patt0$temp;
                    entries.accept((ItemLike)block);
                    continue;
                }
                Object patt1$temp = obj.get();
                if (!(patt1$temp instanceof Item)) continue;
                Item item = (Item)patt1$temp;
                entries.accept((ItemLike)item);
            }
        }).build());
    }

    public static void registerPyriteItem(String itemID) {
        ALL_ITEMS.add((Supplier<Item>)ITEMS.register(itemID, () -> new Item(ModHelpers.newItemSettings(itemID))));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TABS.register(eventBus);
        RESOURCE_BLOCKS.addAll(PyriteItemGroups.WAXED_COPPER_BLOCKS.values());
        RESOURCE_BLOCKS.addAll(PyriteItemGroups.WAXED_EXPOSED_COPPER_BLOCKS.values());
        RESOURCE_BLOCKS.addAll(PyriteItemGroups.WAXED_WEATHERED_COPPER_BLOCKS.values());
        RESOURCE_BLOCKS.addAll(PyriteItemGroups.WAXED_OXIDIZED_COPPER_BLOCKS.values());
        BlockCreatorImpl.addItemGroup("wood_group", WOOD_ICON, WOOD_BLOCKS);
        BlockCreatorImpl.addItemGroup("resource_group", RESOURCE_ICON, RESOURCE_BLOCKS);
        BlockCreatorImpl.addItemGroup("brick_group", BRICK_ICON, BRICK_BLOCKS);
        BlockCreatorImpl.addItemGroup("pyrite_group", MISC_ICON, MISC_BLOCKS);
    }

    @SubscribeEvent
    public static void addSupportedBlocks(BlockEntityTypeAddBlocksEvent event) {
        for (Supplier<Block> sign : SIGN_BLOCKS) {
            event.modify(BlockEntityType.SIGN, new Block[]{sign.get()});
        }
        for (Supplier<Block> sign : HANGING_SIGN_BLOCKS) {
            event.modify(BlockEntityType.HANGING_SIGN, new Block[]{sign.get()});
        }
        if (ModList.get().isLoaded("lolmcv")) {
            ChestsCompat.registerToBlockEntity(event);
        }
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        FlowerPotBlock pot = (FlowerPotBlock)Blocks.FLOWER_POT;
        for (Map.Entry<String, Supplier<FlowerPotBlock>> entry : PyriteItemGroups.POTTED_FLOWERS.entrySet()) {
            String flowerID = entry.getKey();
            Supplier<FlowerPotBlock> flowerPot = entry.getValue();
            pot.addPlant(ModHelpers.locate(flowerID), flowerPot);
        }
    }

    private static /* synthetic */ ItemStack lambda$addItemGroup$52(Supplier icon) {
        return new ItemStack((ItemLike)icon.get());
    }

    private static /* synthetic */ FlowerPotBlock lambda$platformRegister$30(Supplier finalNewBlock, String blockID) {
        return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, finalNewBlock, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).setId(ModHelpers.registryKeyBlock("potted_" + blockID)));
    }

    static {
        BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"pyrite");
        ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"pyrite");
        TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"pyrite");
        ALL_ITEMS = new ArrayList();
        SIGN_BLOCKS = new ArrayList();
        HANGING_SIGN_BLOCKS = new ArrayList();
        WOOD_BLOCKS = new ArrayList();
        RESOURCE_BLOCKS = new ArrayList();
        BRICK_BLOCKS = new ArrayList();
        REDSTONE_BLOCKS = new ArrayList();
        MISC_BLOCKS = new ArrayList();
    }
}

