/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.pyrite.registry.fabric;

import cc.cassian.pyrite.blocks.GravelBlock;
import cc.cassian.pyrite.blocks.ModBlock;
import cc.cassian.pyrite.blocks.ModCarpet;
import cc.cassian.pyrite.blocks.ModCraftingTable;
import cc.cassian.pyrite.blocks.ModFacingBlock;
import cc.cassian.pyrite.blocks.ModGlass;
import cc.cassian.pyrite.blocks.ModPane;
import cc.cassian.pyrite.blocks.ModPillar;
import cc.cassian.pyrite.blocks.ModPressurePlate;
import cc.cassian.pyrite.blocks.ModSlab;
import cc.cassian.pyrite.blocks.ModStairs;
import cc.cassian.pyrite.blocks.ModTorch;
import cc.cassian.pyrite.blocks.ModWall;
import cc.cassian.pyrite.blocks.ModWood;
import cc.cassian.pyrite.blocks.ModWoodenButton;
import cc.cassian.pyrite.blocks.OxidizableBarsBlock;
import cc.cassian.pyrite.blocks.OxidizablePillarBlock;
import cc.cassian.pyrite.blocks.OxidizableWallBlock;
import cc.cassian.pyrite.blocks.OxidizableWallGateBlock;
import cc.cassian.pyrite.blocks.StainedFramedGlass;
import cc.cassian.pyrite.blocks.SwitchableGlass;
import cc.cassian.pyrite.blocks.TorchLever;
import cc.cassian.pyrite.blocks.WallGateBlock;
import cc.cassian.pyrite.compat.ChestsCompat;
import cc.cassian.pyrite.compat.ColumnsCompat;
import cc.cassian.pyrite.functions.ModHelpers;
import cc.cassian.pyrite.functions.fabric.FabricHelpers;
import cc.cassian.pyrite.registry.PyriteItemGroups;
import cc.cassian.pyrite.registry.fabric.PyriteItemGroupsImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1294;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2399;
import net.minecraft.class_2504;
import net.minecraft.class_2508;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5812;
import net.minecraft.class_5813;
import net.minecraft.class_5814;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7923;
import net.minecraft.class_8177;
import net.minecraft.class_8925;
import net.minecraft.class_8927;

public class BlockCreatorImpl {
    public static final LinkedHashMap<String, class_2248> BLOCKS = new LinkedHashMap();
    public static final LinkedHashMap<String, class_2248> ITEMLESS_BLOCKS = new LinkedHashMap();
    public static final LinkedHashMap<String, class_1792> ITEMS = new LinkedHashMap();

    public static class_4719 createWoodType(String blockID, class_8177 setType) {
        return WoodTypeBuilder.copyOf((class_4719)class_4719.field_21676).register(ModHelpers.locate(blockID), setType);
    }

    public static void platformRegister(String blockID, String blockType, class_4970.class_2251 blockSettings, class_4719 woodType, class_8177 blockSetType, class_2394 particle, class_2248 copyBlock, String group, class_3620 color) {
        int power = ModHelpers.power(blockID);
        Object newBlock = null;
        blockSettings = blockSettings.method_63500(ModHelpers.registryKeyBlock(blockID));
        switch (blockType.toLowerCase()) {
            case "block": 
            case "lamp": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new class_5812(ModHelpers.getOxidizationState(blockID), blockSettings.method_9640());
                    ModBlock waxedBlock = new ModBlock(blockSettings);
                    BLOCKS.put("waxed_" + blockID, waxedBlock);
                    PyriteItemGroups.match(() -> waxedBlock, copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxedBlock);
                    break;
                }
                newBlock = new ModBlock(blockSettings, power);
                break;
            }
            case "crafting": {
                boolean burnable;
                boolean bl = burnable = !blockID.contains("crimson") && !blockID.contains("warped");
                if (burnable) {
                    newBlock = new ModCraftingTable(blockSettings.method_50013());
                    FabricHelpers.FUEL_BLOCKS.put((class_2248)newBlock, 300);
                    break;
                }
                newBlock = new ModCraftingTable(blockSettings);
                break;
            }
            case "chest": {
                if (!FabricLoader.getInstance().isModLoaded("lolmcv")) break;
                newBlock = ChestsCompat.registerChest(blockID, blockSettings, group, copyBlock, color);
                ChestsCompat.add((class_2248)newBlock);
                break;
            }
            case "ladder": {
                newBlock = new class_2399(blockSettings);
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "carpet": {
                newBlock = new ModCarpet(blockSettings);
                break;
            }
            case "slab": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new class_5813(ModHelpers.getOxidizationState(blockID), blockSettings);
                    ModSlab waxed = new ModSlab(blockSettings);
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$1((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                    break;
                }
                newBlock = new ModSlab(blockSettings, power);
                break;
            }
            case "stairs": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new class_5814(ModHelpers.getOxidizationState(blockID), copyBlock.method_9564(), blockSettings);
                    ModStairs waxed = new ModStairs(copyBlock.method_9564(), blockSettings);
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                    break;
                }
                newBlock = new ModStairs(copyBlock.method_9564(), blockSettings);
                break;
            }
            case "wall": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new OxidizableWallBlock(ModHelpers.getOxidizationState(blockID), blockSettings);
                    ModWall waxed = new ModWall(blockSettings);
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$2((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                    if (!FabricLoader.getInstance().isModLoaded("columns")) break;
                    ColumnsCompat.registerCopperColumn(blockID, blockSettings, group, copyBlock);
                    break;
                }
                newBlock = new ModWall(blockSettings, power);
                if (!FabricLoader.getInstance().isModLoaded("columns")) break;
                ColumnsCompat.registerColumn(blockID.replace("wall", "column"), blockSettings, group, copyBlock);
                break;
            }
            case "fence": {
                newBlock = new class_2354(blockSettings);
                break;
            }
            case "log": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new OxidizablePillarBlock(ModHelpers.getOxidizationState(blockID), blockSettings);
                    ModPillar waxed = new ModPillar(blockSettings);
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$3((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                    break;
                }
                newBlock = new ModPillar(blockSettings, power);
                break;
            }
            case "wood": {
                newBlock = new ModWood(blockSettings);
                break;
            }
            case "facing": {
                newBlock = new ModFacingBlock(blockSettings, power);
                break;
            }
            case "bars": 
            case "glass_pane": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new OxidizableBarsBlock(ModHelpers.getOxidizationState(blockID), blockSettings);
                    ModPane waxed = new ModPane(blockSettings);
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$4((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                    FabricHelpers.addTransparentBlock((class_2248)waxed);
                } else {
                    newBlock = new ModPane(blockSettings, power);
                }
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "stained_framed_glass_pane": {
                newBlock = new class_2504(ModHelpers.getDyeColorFromFramedId(blockID), blockSettings);
                FabricHelpers.addTranslucentBlock((class_2248)newBlock);
                break;
            }
            case "glass": {
                newBlock = new ModGlass(blockSettings);
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "stained_framed_glass": {
                newBlock = new StainedFramedGlass(ModHelpers.getDyeColorFromFramedId(blockID), blockSettings);
                FabricHelpers.addTranslucentBlock((class_2248)newBlock);
                break;
            }
            case "gravel": {
                newBlock = new GravelBlock(blockSettings);
                break;
            }
            case "flower": {
                newBlock = new class_2356(class_1294.field_5925, 5.0f, blockSettings);
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                class_2362 FLOWER_POTTED = new class_2362((class_2248)newBlock, class_2246.method_63176().method_63500(ModHelpers.registryKeyBlock("potted_" + blockID)));
                ITEMLESS_BLOCKS.put("potted_" + blockID, (class_2248)FLOWER_POTTED);
                FabricHelpers.addTransparentBlock((class_2248)FLOWER_POTTED);
                break;
            }
            case "fence_gate": {
                newBlock = new class_2349(woodType, blockSettings);
                break;
            }
            case "wall_gate": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new OxidizableWallGateBlock(ModHelpers.getOxidizationState(blockID), blockSettings);
                    WallGateBlock waxed = new WallGateBlock(blockSettings);
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$5((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                    break;
                }
                newBlock = new WallGateBlock(blockSettings);
                break;
            }
            case "sign": {
                newBlock = new class_2508(woodType, blockSettings);
                ITEMLESS_BLOCKS.put(blockID, (class_2248)newBlock);
                class_2551 WALL_SIGN = new class_2551(woodType, blockSettings);
                ITEMLESS_BLOCKS.put(blockID.replace("_sign", "_wall_sign"), (class_2248)WALL_SIGN);
                class_1822 SIGN_ITEM = new class_1822((class_2248)newBlock, (class_2248)WALL_SIGN, ModHelpers.newItemSettings(blockID).method_7889(16));
                ITEMS.put(blockID, (class_1792)SIGN_ITEM);
                PyriteItemGroups.SIGNS.add(PyriteItemGroups.SIGNS.size(), () -> BlockCreatorImpl.lambda$platformRegister$6((class_1792)SIGN_ITEM));
                class_2591.field_11911.addSupportedBlock((class_2248)newBlock);
                class_2591.field_11911.addSupportedBlock((class_2248)WALL_SIGN);
                break;
            }
            case "hanging_sign": {
                newBlock = new class_7713(woodType, blockSettings);
                ITEMLESS_BLOCKS.put(blockID, (class_2248)newBlock);
                class_7715 HANGING_WALL_SIGN = new class_7715(woodType, blockSettings);
                ITEMLESS_BLOCKS.put(blockID.replace("_sign", "_wall_sign"), (class_2248)HANGING_WALL_SIGN);
                class_7707 HANGING_SIGN_ITEM = new class_7707((class_2248)newBlock, (class_2248)HANGING_WALL_SIGN, ModHelpers.newItemSettings(blockID).method_7889(16));
                ITEMS.put(blockID, (class_1792)HANGING_SIGN_ITEM);
                PyriteItemGroups.SIGNS.add(() -> BlockCreatorImpl.lambda$platformRegister$7((class_1792)HANGING_SIGN_ITEM));
                class_2591.field_40330.addSupportedBlock((class_2248)newBlock);
                class_2591.field_40330.addSupportedBlock((class_2248)HANGING_WALL_SIGN);
                break;
            }
            case "door": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new class_8925(blockSetType, ModHelpers.getOxidizationState(blockID), blockSettings.method_22488());
                    class_2323 waxed = new class_2323(blockSetType, blockSettings.method_22488());
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$8((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                } else {
                    newBlock = new class_2323(blockSetType, blockSettings.method_22488());
                }
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "trapdoor": {
                if (ModHelpers.isCopper(blockID)) {
                    newBlock = new class_8927(blockSetType, ModHelpers.getOxidizationState(blockID), blockSettings.method_22488());
                    class_2533 waxed = new class_2533(blockSetType, blockSettings.method_22488());
                    BLOCKS.put("waxed_" + blockID, (class_2248)waxed);
                    PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$9((class_2248)waxed), copyBlock, "waxed_" + group, "waxed_" + blockID);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)newBlock, (class_2248)waxed);
                } else {
                    newBlock = new class_2533(blockSetType, blockSettings.method_22488());
                }
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "button": {
                newBlock = new ModWoodenButton(blockSettings, blockSetType);
                break;
            }
            case "pressure_plate": {
                newBlock = new ModPressurePlate(blockSettings, blockSetType);
                break;
            }
            case "torch": {
                class_2394 torchParticle = particle;
                if (particle == null) {
                    torchParticle = class_2398.field_11240;
                }
                newBlock = new ModTorch(blockSettings.method_22488(), torchParticle);
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "torch_lever": {
                newBlock = new TorchLever(blockSettings.method_22488(), particle);
                FabricHelpers.addTransparentBlock((class_2248)newBlock);
                break;
            }
            case "concrete_powder": {
                newBlock = new class_2292(FabricHelpers.getLastBlock(), blockSettings);
                break;
            }
            case "switchable_glass": {
                newBlock = new SwitchableGlass(blockSettings);
                FabricHelpers.addTranslucentBlock((class_2248)newBlock);
                break;
            }
            default: {
                ModHelpers.log("%s created as a generic block, block provided: %s".formatted(blockID, blockType));
                newBlock = new class_2248(blockSettings);
            }
        }
        if (newBlock == null) {
            return;
        }
        if (!blockType.contains("sign")) {
            BLOCKS.put(blockID, (class_2248)newBlock);
        }
        if (blockID.contains("grass")) {
            FabricHelpers.addGrassBlock();
        }
        Object finalNewBlock = newBlock;
        PyriteItemGroups.match(() -> BlockCreatorImpl.lambda$platformRegister$10((class_2248)finalNewBlock), copyBlock, group, blockID);
    }

    public static void registerPyriteItem(String itemID) {
        class_1792 item = new class_1792(ModHelpers.newItemSettings(itemID));
        ITEMS.put(itemID, item);
        PyriteItemGroups.DYES.add(() -> item);
    }

    public static class_1747 addBlockItem(String blockID, class_2248 block) {
        class_1792.class_1793 settings = ModHelpers.newBlockItemSettings(blockID);
        if (blockID.contains("netherite")) {
            settings = settings.method_24359();
        }
        return new class_1747(block, settings);
    }

    public static void register() {
        String blockID;
        class_2248 block;
        for (Map.Entry<String, class_2248> entry : BLOCKS.entrySet()) {
            block = entry.getValue();
            blockID = entry.getKey();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)ModHelpers.locate(blockID), (Object)block);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)ModHelpers.locate(blockID), (Object)BlockCreatorImpl.addBlockItem(blockID, block));
        }
        for (Map.Entry<String, class_2248> entry : ITEMLESS_BLOCKS.entrySet()) {
            block = entry.getValue();
            blockID = entry.getKey();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)ModHelpers.locate(blockID), (Object)block);
        }
        for (Map.Entry<String, class_2248> entry : ITEMS.entrySet()) {
            class_1792 item = (class_1792)entry.getValue();
            String itemID = entry.getKey();
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)ModHelpers.locate(itemID), (Object)item);
        }
        for (Map.Entry<String, Object> entry : PyriteItemGroups.COPPER_BLOCKS.entrySet()) {
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)((class_2248)((Supplier)entry.getValue()).get()), (class_2248)ModHelpers.getBlock(entry.getKey().replace("copper", "exposed_copper")));
        }
        for (Map.Entry<String, Object> entry : PyriteItemGroups.EXPOSED_COPPER_BLOCKS.entrySet()) {
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)((class_2248)((Supplier)entry.getValue()).get()), (class_2248)ModHelpers.getBlock(entry.getKey().replace("exposed", "weathered")));
        }
        for (Map.Entry<String, Object> entry : PyriteItemGroups.WEATHERED_COPPER_BLOCKS.entrySet()) {
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)((class_2248)((Supplier)entry.getValue()).get()), (class_2248)ModHelpers.getBlock(entry.getKey().replace("weathered", "oxidized")));
        }
        PyriteItemGroupsImpl.addItemGroup("pyrite_group", "glowing_obsidian", BLOCKS);
        PyriteItemGroupsImpl.modifyEntries();
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$10(class_2248 finalNewBlock) {
        return finalNewBlock;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$9(class_2248 waxed) {
        return waxed;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$8(class_2248 waxed) {
        return waxed;
    }

    private static /* synthetic */ class_1792 lambda$platformRegister$7(class_1792 HANGING_SIGN_ITEM) {
        return HANGING_SIGN_ITEM;
    }

    private static /* synthetic */ class_1792 lambda$platformRegister$6(class_1792 SIGN_ITEM) {
        return SIGN_ITEM;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$5(class_2248 waxed) {
        return waxed;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$4(class_2248 waxed) {
        return waxed;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$3(class_2248 waxed) {
        return waxed;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$2(class_2248 waxed) {
        return waxed;
    }

    private static /* synthetic */ class_2248 lambda$platformRegister$1(class_2248 waxed) {
        return waxed;
    }
}

