/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets;

import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.keys.KeyInputHandler;
import com.mcjty.fancytrinkets.modules.effects.EffectsModule;
import com.mcjty.fancytrinkets.modules.loot.LootModule;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketsModule;
import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import com.mcjty.fancytrinkets.setup.ClientEventHandlers;
import com.mcjty.fancytrinkets.setup.Config;
import com.mcjty.fancytrinkets.setup.Messages;
import com.mcjty.fancytrinkets.setup.ModSetup;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="fancytrinkets")
public class FancyTrinkets {
    public static final String MODID = "fancytrinkets";
    public static FancyTrinkets instance;
    public static ModSetup setup;
    private final Modules modules = new Modules();

    public FancyTrinkets(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        Config.register(mod);
        this.setupModules(bus);
        Registration.register(bus);
        CustomRegistries.init(bus);
        ShapedRecipePattern.setCraftingSize((int)5, (int)5);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::onDataGen);
        bus.addListener(Messages::registerMessages);
        bus.addListener(Registration::onRegisterCapabilities);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            bus.addListener(ClientEventHandlers::onRegisterKeyMappings);
            NeoForge.EVENT_BUS.register((Object)new KeyInputHandler());
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        setup.datagen(datagen);
        datagen.generate();
    }

    private void setupModules(IEventBus bus) {
        this.modules.register((IModule)new EffectsModule());
        this.modules.register((IModule)new TrinketsModule(bus));
        this.modules.register((IModule)new XpCrafterModule(bus));
        this.modules.register((IModule)new LootModule());
    }

    static {
        setup = new ModSetup();
    }
}

