/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.datapack;

import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.AttributeModifierEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.CureEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.DamageReductionEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.FlightEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.GrowTickEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.MobEffectEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.PotionResistanceEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.WarpEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;

public record EffectDescription(Integer hotkey, String toggle, boolean harmful, IEffectParameters params, IEffect effect) {
    public static final Codec<IEffectParameters> PARAMS_CODEC = Codec.lazyInitialized(() -> Codec.STRING.dispatch("type", s -> s.getType().name().toLowerCase(), EffectDescription::getParameterCodec));
    public static final Codec<EffectDescription> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("hotkey").forGetter(l -> Optional.ofNullable(l.hotkey)), (App)Codec.STRING.optionalFieldOf("toggle").forGetter(l -> Optional.ofNullable(l.toggle)), (App)Codec.BOOL.optionalFieldOf("harmful").forGetter(l -> l.harmful ? Optional.of(l.harmful) : Optional.empty()), (App)PARAMS_CODEC.fieldOf("params").forGetter(l -> l.params)).apply((Applicative)instance, (hotkey, toggle, harmful, params) -> EffectDescription.create(hotkey.orElse(null), toggle.orElse(null), harmful.orElse(false), params)));

    public static EffectDescription create(Integer hotkey, String toggle, boolean harmful, IEffectParameters params) {
        return new EffectDescription(hotkey, toggle, harmful, params, EffectDescription.buildEffect(params, hotkey, toggle));
    }

    private static MapCodec<IEffectParameters> getParameterCodec(String stype) {
        EffectType type = EffectType.valueOf(stype.toUpperCase());
        return type.getCodecSupplier().get();
    }

    private static IEffect buildEffect(IEffectParameters params, Integer hotkey, String toggle) {
        return switch (params.getType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EffectDescription.getMobEffectEffect(params, hotkey, toggle);
            case 1 -> EffectDescription.getPotionResistanceEffect(params, hotkey, toggle);
            case 2 -> EffectDescription.getDamageReductionEffect(params, hotkey, toggle);
            case 3 -> new FlightEffect(hotkey, toggle);
            case 4 -> new WarpEffect(hotkey, toggle, WarpEffect.Params.cast(params).maxdist());
            case 5 -> new CureEffect(hotkey, toggle);
            case 6 -> EffectDescription.getAttributeEffect(params, hotkey, toggle);
            case 7 -> EffectDescription.getGrowTickEffect(params, hotkey, toggle);
        };
    }

    @Nonnull
    private static GrowTickEffect getGrowTickEffect(IEffectParameters params, Integer hotkey, String toggle) {
        GrowTickEffect.Params p = GrowTickEffect.Params.cast(params);
        return new GrowTickEffect(hotkey, toggle, p.maxdist(), p.blocks());
    }

    @Nonnull
    private static AttributeModifierEffect getAttributeEffect(IEffectParameters params, Integer hotkey, String toggle) {
        String effName;
        AttributeModifierEffect.Params p = AttributeModifierEffect.Params.cast(params);
        Holder attributeSupplier = switch (effName = p.effect()) {
            case "step_assist" -> Attributes.STEP_HEIGHT;
            case "swim_speed" -> NeoForgeMod.SWIM_SPEED;
            case "attack_range" -> Attributes.ENTITY_INTERACTION_RANGE;
            case "reach_distance" -> Attributes.BLOCK_INTERACTION_RANGE;
            case "max_health" -> Attributes.MAX_HEALTH;
            case "knockback_resistance" -> Attributes.KNOCKBACK_RESISTANCE;
            case "movement_speed" -> Attributes.MOVEMENT_SPEED;
            case "attack_speed" -> Attributes.ATTACK_SPEED;
            case "attack_damage" -> Attributes.ATTACK_DAMAGE;
            case "luck" -> Attributes.LUCK;
            default -> throw new RuntimeException("Bad attribute effectId '" + effName + "'!");
        };
        return new AttributeModifierEffect(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)effName), hotkey, toggle, effName, (Holder<Attribute>)attributeSupplier, p.operation(), p.amount());
    }

    @Nonnull
    private static MobEffectEffect getMobEffectEffect(IEffectParameters params, Integer hotkey, String toggle) {
        MobEffectEffect.Params p = MobEffectEffect.Params.cast(params);
        String effName = p.effect();
        Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effName));
        if (effect.isEmpty()) {
            throw new RuntimeException("Can't find effectId '" + effName + "'!");
        }
        return new MobEffectEffect(hotkey, toggle, (Holder<MobEffect>)((Holder)effect.get()), p.strength() - 1);
    }

    @Nonnull
    private static PotionResistanceEffect getPotionResistanceEffect(IEffectParameters params, Integer hotkey, String toggle) {
        PotionResistanceEffect.Params p = PotionResistanceEffect.Params.cast(params);
        String effName = p.effect();
        Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effName));
        if (effect.isEmpty()) {
            throw new RuntimeException("Can't find effectId '" + effName + "'!");
        }
        return new PotionResistanceEffect(hotkey, toggle, (Holder<MobEffect>)((Holder)effect.get()));
    }

    @Nonnull
    private static DamageReductionEffect getDamageReductionEffect(IEffectParameters params, Integer hotkey, String toggle) {
        DamageReductionEffect.Params p = DamageReductionEffect.Params.cast(params);
        String dmgId = p.dmgId();
        float factor = p.factor();
        return new DamageReductionEffect(hotkey, toggle, dmgId, factor);
    }

    public static enum EffectType {
        MOBEFFECT(() -> MobEffectEffect.CODEC),
        POTIONRESISTANCE(() -> PotionResistanceEffect.CODEC),
        DAMAGEREDUCTION(() -> DamageReductionEffect.CODEC),
        FLIGHT(() -> FlightEffect.CODEC),
        WARP(() -> WarpEffect.CODEC),
        CURE(() -> CureEffect.CODEC),
        ATTRIBUTE(() -> AttributeModifierEffect.CODEC),
        GROWTICK(() -> GrowTickEffect.CODEC);

        private final Supplier<MapCodec<IEffectParameters>> codecSupplier;

        private EffectType(Supplier<MapCodec<IEffectParameters>> codecSupplier) {
            this.codecSupplier = codecSupplier;
        }

        public Supplier<MapCodec<IEffectParameters>> getCodecSupplier() {
            return this.codecSupplier;
        }
    }
}

