/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.datapack;

import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.modules.effects.EffectInstance;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.Tools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record TrinketDescription(ResourceLocation item, ResourceLocation bonusTableId, String nameKey, String descriptionKey, List<EffectRef> effects) {
    public static final Codec<TrinketDescription> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("item").forGetter(l -> l.item), (App)ResourceLocation.CODEC.fieldOf("bonustable").forGetter(l -> l.bonusTableId), (App)Codec.STRING.fieldOf("name").forGetter(l -> l.nameKey), (App)Codec.STRING.fieldOf("description").forGetter(l -> l.descriptionKey), (App)Codec.list(EffectRef.EFFECTREF_CODEC).fieldOf("effects").forGetter(l -> l.effects)).apply((Applicative)instance, TrinketDescription::new));

    public TrinketInstance build(ResourceLocation id, Level level) {
        ArrayList<EffectInstance> effectInstances = new ArrayList<EffectInstance>();
        for (EffectRef effectRef : this.effects) {
            EffectDescription effectDescription = (EffectDescription)Tools.getRegistryAccess((Level)level).registryOrThrow(CustomRegistries.EFFECT_REGISTRY_KEY).get(effectRef.effectId());
            if (effectDescription == null) {
                throw new RuntimeException("Can't find effectId '" + effectRef.effectId().toString() + "'!");
            }
            effectInstances.add(new EffectInstance(effectRef.effectId(), effectRef.hidden, effectDescription.effect()));
        }
        return new TrinketInstance(id, this.bonusTableId, this.nameKey, this.descriptionKey, effectInstances);
    }

    public record EffectRef(ResourceLocation effectId, boolean hidden) {
        public static final Codec<EffectRef> EFFECTREF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(l -> l.effectId), (App)Codec.BOOL.fieldOf("hidden").forGetter(l -> l.hidden)).apply((Applicative)instance, EffectRef::new));
    }
}

