/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.modules.effects.imp.AttributeModifierEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.CureEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.DamageReductionEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.FlightEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.GrowTickEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.MobEffectEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.PotionResistanceEffect;
import com.mcjty.fancytrinkets.modules.effects.imp.WarpEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class DefaultEffects {
    public static final Map<ResourceLocation, EffectInfo> DEFAULT_EFFECTS = new HashMap<ResourceLocation, EffectInfo>();

    static void init() {
        DEFAULT_EFFECTS.clear();
        DefaultEffects.register("weakness", DefaultEffects.mobEffect("minecraft:weakness", 1, true), "Weakness");
        DefaultEffects.register("blindness", DefaultEffects.mobEffect("minecraft:blindness", 1, true), "Blindness");
        DefaultEffects.register("slowness", DefaultEffects.mobEffect("minecraft:slowness", 1, true), "Slowness");
        DefaultEffects.register("mining_fatigue", DefaultEffects.mobEffect("minecraft:mining_fatigue", 1, true), "Mining Fatigue");
        DefaultEffects.register("nausea", DefaultEffects.mobEffect("minecraft:nausea", 1, true), "Nausea");
        DefaultEffects.register("hunger", DefaultEffects.mobEffect("minecraft:hunger", 1, true), "Hunger");
        DefaultEffects.register("poison", DefaultEffects.mobEffect("minecraft:poison", 1, true), "Poison");
        DefaultEffects.register("wither", DefaultEffects.mobEffect("minecraft:wither", 1, true), "Wither");
        DefaultEffects.register("bad_omen", DefaultEffects.mobEffect("minecraft:bad_omen", 1, true), "Bad Omen");
        DefaultEffects.register("dmg_infire_debuff", DefaultEffects.damageModificationEffect("inFire", 1.25f), "In Fire Damage Weakness (+25%)");
        DefaultEffects.register("dmg_lightningbolt_debuff", DefaultEffects.damageModificationEffect("lightningBolt", 1.25f), "Lightning Bolt Damage Weakness (+25%)");
        DefaultEffects.register("dmg_onfire_debuff", DefaultEffects.damageModificationEffect("onFire", 1.25f), "On Fire Damage Weakness (+25%)");
        DefaultEffects.register("dmg_lava_debuff", DefaultEffects.damageModificationEffect("lava", 1.25f), "Lava Damage Weakness (+25%)");
        DefaultEffects.register("dmg_hotfloor_debuff", DefaultEffects.damageModificationEffect("hotFloor", 1.25f), "Hot Floor Damage Weakness (+25%)");
        DefaultEffects.register("dmg_inwall_debuff", DefaultEffects.damageModificationEffect("inWall", 1.25f), "Suffocation Damage Weakness (+25%)");
        DefaultEffects.register("dmg_cramming_debuff", DefaultEffects.damageModificationEffect("cramming", 1.25f), "Cramming Damage Weakness (+25%)");
        DefaultEffects.register("dmg_drown_debuff", DefaultEffects.damageModificationEffect("drown", 1.25f), "Drowning Damage Weakness (+25%)");
        DefaultEffects.register("dmg_starve_debuff", DefaultEffects.damageModificationEffect("starve", 1.25f), "Starving Damage Weakness (+25%)");
        DefaultEffects.register("dmg_cactus_debuff", DefaultEffects.damageModificationEffect("cactus", 1.25f), "Cactus Damage Weakness (+25%)");
        DefaultEffects.register("dmg_fall_debuff", DefaultEffects.damageModificationEffect("fall", 1.25f), "Fall Damage Weakness (+25%)");
        DefaultEffects.register("dmg_flyintowall_debuff", DefaultEffects.damageModificationEffect("flyIntoWall", 1.25f), "Fly Into Wall Damage Weakness (+25%)");
        DefaultEffects.register("dmg_outofworld_debuff", DefaultEffects.damageModificationEffect("outOfWorld", 1.25f), "Out Of World Damage Weakness (+25%)");
        DefaultEffects.register("dmg_generic_debuff", DefaultEffects.damageModificationEffect("generic", 1.25f), "Generic Damage Weakness (+25%)");
        DefaultEffects.register("dmg_magic_debuff", DefaultEffects.damageModificationEffect("magic", 1.25f), "Magic Damage Weakness (+25%)");
        DefaultEffects.register("dmg_wither_debuff", DefaultEffects.damageModificationEffect("wither", 1.25f), "Wither Damage Weakness (+25%)");
        DefaultEffects.register("dmg_anvil_debuff", DefaultEffects.damageModificationEffect("anvil", 1.25f), "Anvil Damage Weakness (+25%)");
        DefaultEffects.register("dmg_fallingblock_debuff", DefaultEffects.damageModificationEffect("fallingBlock", 1.25f), "Falling Block Damage Weakness (+25%)");
        DefaultEffects.register("dmg_dragonbreath_debuff", DefaultEffects.damageModificationEffect("dragonBreath", 1.25f), "Dragon Breath Damage Weakness (+25%)");
        DefaultEffects.register("dmg_dryout_debuff", DefaultEffects.damageModificationEffect("dryout", 1.25f), "Dryout Damage Weakness (+25%)");
        DefaultEffects.register("dmg_sweetberrybush_debuff", DefaultEffects.damageModificationEffect("sweetBerryBush", 1.25f), "Sweet Berry Bush Damage Weakness (+25%)");
        DefaultEffects.register("dmg_freeze_debuff", DefaultEffects.damageModificationEffect("freeze", 1.25f), "Freeze Damage Weakness (+25%)");
        DefaultEffects.register("dmg_fallingstalactite_debuff", DefaultEffects.damageModificationEffect("fallingStalactite", 1.25f), "Falling Stalactite Damage Weakness (+25%)");
        DefaultEffects.register("dmg_stalagmite_debuff", DefaultEffects.damageModificationEffect("stalagmite", 1.25f), "Stalagmite Damage Weakness (+25%)");
        DefaultEffects.register("swim_speed_debuff", DefaultEffects.attributeEffect("swim_speed", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.9), "Swim Speed Reduction (-10%)");
        DefaultEffects.register("attack_range_debuff", DefaultEffects.attributeEffect("attack_range", AttributeModifier.Operation.ADD_VALUE, -0.5), "Attack Range Reduction (-.5)");
        DefaultEffects.register("reach_distance_debuff", DefaultEffects.attributeEffect("reach_distance", AttributeModifier.Operation.ADD_VALUE, -0.5), "Reach Distance Reduction (-.5)");
        DefaultEffects.register("max_health_debuff", DefaultEffects.attributeEffect("max_health", AttributeModifier.Operation.ADD_VALUE, -1.0), "Max Health Reduction (-1)");
        DefaultEffects.register("movement_speed_debuff", DefaultEffects.attributeEffect("movement_speed", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.9), "Movement Speed Reduction (-10%)");
        DefaultEffects.register("attack_speed_debuff", DefaultEffects.attributeEffect("attack_speed", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.8), "Attack Speed Reduction (-20%)");
        DefaultEffects.register("attack_damage_debuff", DefaultEffects.attributeEffect("attack_damage", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.75), "Attack Damage Reduction (-25%)");
        DefaultEffects.register("regeneration", DefaultEffects.mobEffect("minecraft:regeneration", 1, false), "Regeneration");
        DefaultEffects.register("strength", DefaultEffects.mobEffect("minecraft:strength", 1, false), "Strength");
        DefaultEffects.register("absorption", DefaultEffects.mobEffect("minecraft:absorption", 1, false), "Absorption");
        DefaultEffects.register("damage_resistance", DefaultEffects.mobEffect("minecraft:resistance", 1, false), "Damage Resistance");
        DefaultEffects.register("haste", DefaultEffects.mobEffect("minecraft:haste", 1, false), "Haste");
        DefaultEffects.register("health_boost", DefaultEffects.mobEffect("minecraft:health_boost", 1, false), "Health Boost");
        DefaultEffects.register("invisibility", DefaultEffects.mobEffect("minecraft:invisibility", 1, false), "Invisibility");
        DefaultEffects.register("night_vision", DefaultEffects.mobEffect("minecraft:night_vision", 1, false), "Nightvision");
        DefaultEffects.register("night_vision_hotkey", DefaultEffects.mobEffect("minecraft:night_vision", 1, 1, "night_vision"), "Nightvision");
        DefaultEffects.register("slow_falling", DefaultEffects.mobEffect("minecraft:slow_falling", 1, false), "Slow Falling");
        DefaultEffects.register("speed", DefaultEffects.mobEffect("minecraft:speed", 1, false), "Speed");
        DefaultEffects.register("jump_boost", DefaultEffects.mobEffect("minecraft:jump_boost", 1, false), "Jump Boost");
        DefaultEffects.register("fire_resistance", DefaultEffects.mobEffect("minecraft:fire_resistance", 1, false), "Fire Resistance");
        DefaultEffects.register("water_breathing", DefaultEffects.mobEffect("minecraft:water_breathing", 1, false), "Water Breathing");
        DefaultEffects.register("saturation", DefaultEffects.mobEffect("minecraft:saturation", 1, false), "Saturation");
        DefaultEffects.register("levitation", DefaultEffects.mobEffect("minecraft:levitation", 1, false), "Levitation");
        DefaultEffects.register("luck_potion", DefaultEffects.mobEffect("minecraft:luck", 1, false), "Luck");
        DefaultEffects.register("conduit_power", DefaultEffects.mobEffect("minecraft:conduit_power", 1, false), "Conduit Power");
        DefaultEffects.register("flight", DefaultEffects.flightEffect(), "Flight");
        DefaultEffects.register("warp", DefaultEffects.warpEffect(2, 40), "Warp");
        DefaultEffects.register("cure", DefaultEffects.cureEffect(), "Cure");
        DefaultEffects.register("growtick", DefaultEffects.growtickEffect(), "Grow Tick Increase");
        DefaultEffects.register("poison_resist", DefaultEffects.potionResistEffect("minecraft:poison"), "Poison Resistance");
        DefaultEffects.register("weakness_resist", DefaultEffects.potionResistEffect("minecraft:weakness"), "Weakness Resistance");
        DefaultEffects.register("wither_resist", DefaultEffects.potionResistEffect("minecraft:wither"), "Wither Resistance");
        DefaultEffects.register("bad_omen_resist", DefaultEffects.potionResistEffect("minecraft:bad_omen"), "Bad Omen Resistance");
        DefaultEffects.register("nausea_resist", DefaultEffects.potionResistEffect("minecraft:nausea"), "Nausea Resistance");
        DefaultEffects.register("blindness_resist", DefaultEffects.potionResistEffect("minecraft:blindness"), "Blindness Resistance");
        DefaultEffects.register("dmg_infire_100", DefaultEffects.damageModificationEffect("inFire", 0.0f), "In Fire Damage Reduction (100%)");
        DefaultEffects.register("dmg_lightningbolt_100", DefaultEffects.damageModificationEffect("lightningBolt", 0.0f), "Lightning Bolt Damage Reduction (100%)");
        DefaultEffects.register("dmg_onfire_100", DefaultEffects.damageModificationEffect("onFire", 0.0f), "On Fire Damage Reduction (100%)");
        DefaultEffects.register("dmg_lava_100", DefaultEffects.damageModificationEffect("lava", 0.0f), "Lava Damage Reduction (100%)");
        DefaultEffects.register("dmg_hotfloor_100", DefaultEffects.damageModificationEffect("hotFloor", 0.0f), "Hot Floor Damage Reduction (100%)");
        DefaultEffects.register("dmg_inwall_100", DefaultEffects.damageModificationEffect("inWall", 0.0f), "Suffocation Damage Reduction (100%)");
        DefaultEffects.register("dmg_cramming_100", DefaultEffects.damageModificationEffect("cramming", 0.0f), "Cramming Damage Reduction (100%)");
        DefaultEffects.register("dmg_drown_100", DefaultEffects.damageModificationEffect("drown", 0.0f), "Drowning Damage Reduction (100%)");
        DefaultEffects.register("dmg_starve_100", DefaultEffects.damageModificationEffect("starve", 0.0f), "Starving Damage Reduction (100%)");
        DefaultEffects.register("dmg_cactus_100", DefaultEffects.damageModificationEffect("cactus", 0.0f), "Cactus Damage Reduction (100%)");
        DefaultEffects.register("dmg_fall_100", DefaultEffects.damageModificationEffect("fall", 0.0f), "Fall Damage Reduction (100%)");
        DefaultEffects.register("dmg_flyintowall_100", DefaultEffects.damageModificationEffect("flyIntoWall", 0.0f), "Fly Into Wall Damage Reduction (100%)");
        DefaultEffects.register("dmg_outofworld_100", DefaultEffects.damageModificationEffect("outOfWorld", 0.0f), "Out Of World Damage Reduction (100%)");
        DefaultEffects.register("dmg_generic_100", DefaultEffects.damageModificationEffect("generic", 0.0f), "Generic Damage Reduction (100%)");
        DefaultEffects.register("dmg_magic_100", DefaultEffects.damageModificationEffect("magic", 0.0f), "Magic Damage Reduction (100%)");
        DefaultEffects.register("dmg_wither_100", DefaultEffects.damageModificationEffect("wither", 0.0f), "Wither Damage Reduction (100%)");
        DefaultEffects.register("dmg_anvil_100", DefaultEffects.damageModificationEffect("anvil", 0.0f), "Anvil Damage Reduction (100%)");
        DefaultEffects.register("dmg_fallingblock_100", DefaultEffects.damageModificationEffect("fallingBlock", 0.0f), "Falling Block Damage Reduction (100%)");
        DefaultEffects.register("dmg_dragonbreath_100", DefaultEffects.damageModificationEffect("dragonBreath", 0.0f), "Dragon Breath Damage Reduction (100%)");
        DefaultEffects.register("dmg_dryout_100", DefaultEffects.damageModificationEffect("dryout", 0.0f), "Dryout Damage Reduction (100%)");
        DefaultEffects.register("dmg_sweetberrybush_100", DefaultEffects.damageModificationEffect("sweetBerryBush", 0.0f), "Sweet Berry Bush Damage Reduction (100%)");
        DefaultEffects.register("dmg_freeze_100", DefaultEffects.damageModificationEffect("freeze", 0.0f), "Freeze Damage Reduction (100%)");
        DefaultEffects.register("dmg_fallingstalactite_100", DefaultEffects.damageModificationEffect("fallingStalactite", 0.0f), "Falling Stalactite Damage Reduction (100%)");
        DefaultEffects.register("dmg_stalagmite_100", DefaultEffects.damageModificationEffect("stalagmite", 0.0f), "Stalagmite Damage Reduction (100%)");
        DefaultEffects.register("dmg_infire_75", DefaultEffects.damageModificationEffect("inFire", 0.25f), "In Fire Damage Reduction (75%)");
        DefaultEffects.register("dmg_lightningbolt_75", DefaultEffects.damageModificationEffect("lightningBolt", 0.25f), "Lightning Bolt Damage Reduction (75%)");
        DefaultEffects.register("dmg_onfire_75", DefaultEffects.damageModificationEffect("onFire", 0.25f), "On Fire Damage Reduction (75%)");
        DefaultEffects.register("dmg_lava_75", DefaultEffects.damageModificationEffect("lava", 0.25f), "Lava Damage Reduction (75%)");
        DefaultEffects.register("dmg_hotfloor_75", DefaultEffects.damageModificationEffect("hotFloor", 0.25f), "Hot Floor Damage Reduction (75%)");
        DefaultEffects.register("dmg_inwall_75", DefaultEffects.damageModificationEffect("inWall", 0.25f), "Suffocation Damage Reduction (75%)");
        DefaultEffects.register("dmg_cramming_75", DefaultEffects.damageModificationEffect("cramming", 0.25f), "Cramming Damage Reduction (75%)");
        DefaultEffects.register("dmg_drown_75", DefaultEffects.damageModificationEffect("drown", 0.25f), "Drowning Damage Reduction (75%)");
        DefaultEffects.register("dmg_starve_75", DefaultEffects.damageModificationEffect("starve", 0.25f), "Starving Damage Reduction (75%)");
        DefaultEffects.register("dmg_cactus_75", DefaultEffects.damageModificationEffect("cactus", 0.25f), "Cactus Damage Reduction (75%)");
        DefaultEffects.register("dmg_fall_75", DefaultEffects.damageModificationEffect("fall", 0.25f), "Fall Damage Reduction (75%)");
        DefaultEffects.register("dmg_flyintowall_75", DefaultEffects.damageModificationEffect("flyIntoWall", 0.25f), "Fly Into Wall Damage Reduction (75%)");
        DefaultEffects.register("dmg_outofworld_75", DefaultEffects.damageModificationEffect("outOfWorld", 0.25f), "Out Of World Damage Reduction (75%)");
        DefaultEffects.register("dmg_generic_75", DefaultEffects.damageModificationEffect("generic", 0.25f), "Generic Damage Reduction (75%)");
        DefaultEffects.register("dmg_magic_75", DefaultEffects.damageModificationEffect("magic", 0.25f), "Magic Damage Reduction (75%)");
        DefaultEffects.register("dmg_wither_75", DefaultEffects.damageModificationEffect("wither", 0.25f), "Wither Damage Reduction (75%)");
        DefaultEffects.register("dmg_anvil_75", DefaultEffects.damageModificationEffect("anvil", 0.25f), "Anvil Damage Reduction (75%)");
        DefaultEffects.register("dmg_fallingblock_75", DefaultEffects.damageModificationEffect("fallingBlock", 0.25f), "Falling Block Damage Reduction (75%)");
        DefaultEffects.register("dmg_dragonbreath_75", DefaultEffects.damageModificationEffect("dragonBreath", 0.25f), "Dragon Breath Damage Reduction (75%)");
        DefaultEffects.register("dmg_dryout_75", DefaultEffects.damageModificationEffect("dryout", 0.25f), "Dryout Damage Reduction (75%)");
        DefaultEffects.register("dmg_sweetberrybush_75", DefaultEffects.damageModificationEffect("sweetBerryBush", 0.25f), "Sweet Berry Bush Damage Reduction (75%)");
        DefaultEffects.register("dmg_freeze_75", DefaultEffects.damageModificationEffect("freeze", 0.25f), "Freeze Damage Reduction (75%)");
        DefaultEffects.register("dmg_fallingstalactite_75", DefaultEffects.damageModificationEffect("fallingStalactite", 0.25f), "Falling Stalactite Damage Reduction (75%)");
        DefaultEffects.register("dmg_stalagmite_75", DefaultEffects.damageModificationEffect("stalagmite", 0.25f), "Stalagmite Damage Reduction (75%)");
        DefaultEffects.register("dmg_infire_50", DefaultEffects.damageModificationEffect("inFire", 0.5f), "In Fire Damage Reduction (50%)");
        DefaultEffects.register("dmg_lightningbolt_50", DefaultEffects.damageModificationEffect("lightningBolt", 0.5f), "Lightning Bolt Damage Reduction (50%)");
        DefaultEffects.register("dmg_onfire_50", DefaultEffects.damageModificationEffect("onFire", 0.5f), "On Fire Damage Reduction (50%)");
        DefaultEffects.register("dmg_lava_50", DefaultEffects.damageModificationEffect("lava", 0.5f), "Lava Damage Reduction (50%)");
        DefaultEffects.register("dmg_hotfloor_50", DefaultEffects.damageModificationEffect("hotFloor", 0.5f), "Hot Floor Damage Reduction (50%)");
        DefaultEffects.register("dmg_inwall_50", DefaultEffects.damageModificationEffect("inWall", 0.5f), "Suffocation Damage Reduction (50%)");
        DefaultEffects.register("dmg_cramming_50", DefaultEffects.damageModificationEffect("cramming", 0.5f), "Cramming Damage Reduction (50%)");
        DefaultEffects.register("dmg_drown_50", DefaultEffects.damageModificationEffect("drown", 0.5f), "Drowning Damage Reduction (50%)");
        DefaultEffects.register("dmg_starve_50", DefaultEffects.damageModificationEffect("starve", 0.5f), "Starving Damage Reduction (50%)");
        DefaultEffects.register("dmg_cactus_50", DefaultEffects.damageModificationEffect("cactus", 0.5f), "Cactus Damage Reduction (50%)");
        DefaultEffects.register("dmg_fall_50", DefaultEffects.damageModificationEffect("fall", 0.5f), "Fall Damage Reduction (50%)");
        DefaultEffects.register("dmg_flyintowall_50", DefaultEffects.damageModificationEffect("flyIntoWall", 0.5f), "Fly Into Wall Damage Reduction (50%)");
        DefaultEffects.register("dmg_outofworld_50", DefaultEffects.damageModificationEffect("outOfWorld", 0.5f), "Out Of World Damage Reduction (50%)");
        DefaultEffects.register("dmg_generic_50", DefaultEffects.damageModificationEffect("generic", 0.5f), "Generic Damage Reduction (50%)");
        DefaultEffects.register("dmg_magic_50", DefaultEffects.damageModificationEffect("magic", 0.5f), "Magic Damage Reduction (50%)");
        DefaultEffects.register("dmg_wither_50", DefaultEffects.damageModificationEffect("wither", 0.5f), "Wither Damage Reduction (50%)");
        DefaultEffects.register("dmg_anvil_50", DefaultEffects.damageModificationEffect("anvil", 0.5f), "Anvil Damage Reduction (50%)");
        DefaultEffects.register("dmg_fallingblock_50", DefaultEffects.damageModificationEffect("fallingBlock", 0.5f), "Falling Block Damage Reduction (50%)");
        DefaultEffects.register("dmg_dragonbreath_50", DefaultEffects.damageModificationEffect("dragonBreath", 0.5f), "Dragon Breath Damage Reduction (50%)");
        DefaultEffects.register("dmg_dryout_50", DefaultEffects.damageModificationEffect("dryout", 0.5f), "Dryout Damage Reduction (50%)");
        DefaultEffects.register("dmg_sweetberrybush_50", DefaultEffects.damageModificationEffect("sweetBerryBush", 0.5f), "Sweet Berry Bush Damage Reduction (50%)");
        DefaultEffects.register("dmg_freeze_50", DefaultEffects.damageModificationEffect("freeze", 0.5f), "Freeze Damage Reduction (50%)");
        DefaultEffects.register("dmg_fallingstalactite_50", DefaultEffects.damageModificationEffect("fallingStalactite", 0.5f), "Falling Stalactite Damage Reduction (50%)");
        DefaultEffects.register("dmg_stalagmite_50", DefaultEffects.damageModificationEffect("stalagmite", 0.5f), "Stalagmite Damage Reduction (50%)");
        DefaultEffects.register("step_assist", DefaultEffects.attributeEffect("step_assist", AttributeModifier.Operation.ADD_VALUE, 0.5), "Step assist");
        DefaultEffects.register("swim_speed", DefaultEffects.attributeEffect("swim_speed", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 2.0), "Swim speed");
        DefaultEffects.register("attack_range", DefaultEffects.attributeEffect("attack_range", AttributeModifier.Operation.ADD_VALUE, 1.0), "Attack Range");
        DefaultEffects.register("reach_distance", DefaultEffects.attributeEffect("reach_distance", AttributeModifier.Operation.ADD_VALUE, 2.0), "Reach Distance");
        DefaultEffects.register("minor_max_health", DefaultEffects.attributeEffect("max_health", AttributeModifier.Operation.ADD_VALUE, 2.0), "Minor Max Health");
        DefaultEffects.register("max_health", DefaultEffects.attributeEffect("max_health", AttributeModifier.Operation.ADD_VALUE, 4.0), "Max Health");
        DefaultEffects.register("major_max_health", DefaultEffects.attributeEffect("max_health", AttributeModifier.Operation.ADD_VALUE, 8.0), "Major Max Health");
        DefaultEffects.register("knockback_resistance", DefaultEffects.attributeEffect("knockback_resistance", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 2.0), "Knockback Resistance");
        DefaultEffects.register("movement_speed", DefaultEffects.attributeEffect("movement_speed", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 2.0), "Movement Speed");
        DefaultEffects.register("attack_speed", DefaultEffects.attributeEffect("attack_speed", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 2.0), "Attack Speed");
        DefaultEffects.register("attack_damage", DefaultEffects.attributeEffect("attack_damage", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 2.0), "Attack Damage");
        DefaultEffects.register("luck", DefaultEffects.attributeEffect("luck", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 2.0), "Luck");
    }

    private static void register(String id, EffectDescription effect, String description) {
        DEFAULT_EFFECTS.put(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)id), new EffectInfo(effect, description));
    }

    private static EffectDescription damageModificationEffect(String dmgId, float factor) {
        return EffectDescription.create(null, null, factor > 1.0f, new DamageReductionEffect.Params(dmgId, factor));
    }

    private static EffectDescription potionResistEffect(String effect) {
        return EffectDescription.create(null, null, false, new PotionResistanceEffect.Params(effect));
    }

    private static EffectDescription mobEffect(String effect, int level, boolean harmful) {
        return EffectDescription.create(null, null, harmful, new MobEffectEffect.Params(effect, level));
    }

    private static EffectDescription mobEffect(String effect, int level, Integer hotkey, String toggle) {
        return EffectDescription.create(hotkey, toggle, false, new MobEffectEffect.Params(effect, level));
    }

    private static EffectDescription attributeEffect(String effect, AttributeModifier.Operation operation, double amount) {
        boolean harmful = false;
        if (operation == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL && amount < 1.0) {
            harmful = true;
        } else if (operation == AttributeModifier.Operation.ADD_VALUE && amount < 0.0) {
            harmful = true;
        }
        return EffectDescription.create(null, null, harmful, new AttributeModifierEffect.Params(effect, operation, amount));
    }

    private static EffectDescription flightEffect() {
        return EffectDescription.create(null, null, false, FlightEffect.Params.EMPTY);
    }

    private static EffectDescription warpEffect(int hotkey, int maxdist) {
        return EffectDescription.create(hotkey, null, false, new WarpEffect.Params(maxdist));
    }

    private static EffectDescription cureEffect() {
        return EffectDescription.create(null, null, false, CureEffect.Params.EMPTY);
    }

    private static EffectDescription growtickEffect() {
        return EffectDescription.create(null, null, false, new GrowTickEffect.Params(6, 15));
    }

    public record EffectInfo(EffectDescription effect, String description) {
    }
}

