/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class AttributeModifierEffect
extends EffectImp {
    private final ResourceLocation id;
    private final AttributeModifier modifier;
    private final Holder<Attribute> attribute;
    public static final MapCodec<IEffectParameters> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("effectId").forGetter(l -> ((Params)l).effect), (App)Codec.STRING.fieldOf("operation").forGetter(l -> ((Params)l).operation.name().toLowerCase()), (App)Codec.DOUBLE.fieldOf("amount").forGetter(l -> ((Params)l).amount)).apply((Applicative)instance, (effect, operation, amount) -> new Params((String)effect, AttributeModifier.Operation.valueOf((String)operation.toUpperCase()), (Double)amount)));

    public AttributeModifierEffect(ResourceLocation id, Integer hotkey, String toggle, String name, Holder<Attribute> attibute, AttributeModifier.Operation operation, double amount) {
        super(hotkey, toggle);
        this.attribute = attibute;
        this.id = id;
        this.modifier = new AttributeModifier(id, amount, operation);
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
        if (!player.isCreative()) {
            this.executeIfEnabled(player, () -> {
                AttributeInstance instance = player.getAttribute(this.attribute);
                if (instance != null && instance.getModifier(this.id) == null) {
                    instance.addTransientModifier(this.modifier);
                }
            });
        }
    }

    @Override
    protected void turnOff(ServerPlayer player) {
        AttributeInstance instance;
        if (!player.isCreative() && (instance = player.getAttribute(this.attribute)) != null) {
            instance.removeModifier(this.id);
        }
    }

    public record Params(String effect, AttributeModifier.Operation operation, Double amount) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.ATTRIBUTE;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

