/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mcjty.fancytrinkets.playerdata.PlayerEffects;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FlightEffect
extends EffectImp {
    public static final MapCodec<IEffectParameters> CODEC = MapCodec.unit((Object)Params.EMPTY);

    public FlightEffect(Integer hotkey, String toggle) {
        super(hotkey, toggle);
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
        if (!player.isCreative()) {
            this.executeIfEnabled(player, () -> {
                if (!player.getAbilities().mayfly) {
                    player.getAbilities().mayfly = true;
                    player.onUpdateAbilities();
                }
            });
        }
    }

    @Override
    public void onHotkey(ItemStack stack, ServerPlayer player, String slotId, int key) {
        PlayerEffects playerEffects;
        if (this.toggle != null && Objects.equals(key, this.hotkey) && !(playerEffects = PlayerEffects.getPlayerEffects((Player)player)).toggle(player, this.toggle)) {
            this.turnOff(player);
        }
    }

    @Override
    protected void turnOff(ServerPlayer player) {
        if (!player.isCreative()) {
            player.getAbilities().flying = false;
            player.getAbilities().mayfly = false;
            player.onUpdateAbilities();
        }
    }

    public record Params() implements IEffectParameters
    {
        public static final Params EMPTY = new Params();

        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.FLIGHT;
        }
    }
}

