/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class GrowTickEffect
extends EffectImp {
    private static final RandomSource random = RandomSource.create();
    private final int maxdist;
    private final int blocks;
    public static final MapCodec<IEffectParameters> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("maxdist").forGetter(l -> ((Params)l).maxdist), (App)Codec.INT.fieldOf("blocks").forGetter(l -> ((Params)l).blocks)).apply((Applicative)instance, Params::new));

    public GrowTickEffect(Integer hotkey, String toggle, int maxdist, int blocks) {
        super(hotkey, toggle);
        this.maxdist = maxdist;
        this.blocks = blocks;
    }

    @Override
    public void tick(ItemStack stack, ServerPlayer player, String slotId) {
        this.executeIfEnabled(player, () -> {
            BlockPos blockPos = player.blockPosition();
            for (int i = 0; i < this.blocks; ++i) {
                int dx = random.nextInt(this.maxdist * 2) - this.maxdist;
                int dy = random.nextInt(6) - 3;
                int dz = random.nextInt(this.maxdist * 2) - this.maxdist;
                BlockPos dest = blockPos.offset(dx, dy, dz);
                player.level().getBlockState(dest).randomTick((ServerLevel)player.level(), dest, random);
            }
        });
    }

    public record Params(int maxdist, int blocks) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.GROWTICK;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

