/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.effects.imp;

import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.IEffectParameters;
import com.mcjty.fancytrinkets.modules.effects.imp.EffectImp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.varia.SoundTools;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WarpEffect
extends EffectImp {
    private final int maxdist;
    public static final MapCodec<IEffectParameters> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("maxdist").forGetter(l -> ((Params)l).maxdist)).apply((Applicative)instance, Params::new));

    public WarpEffect(Integer hotkey, String toggle, int maxdist) {
        super(hotkey, toggle);
        this.maxdist = maxdist;
    }

    @Override
    public void onHotkey(ItemStack stack, ServerPlayer player, String slotId, int key) {
        if (Objects.equals(key, this.hotkey)) {
            this.executeIfEnabled(player, () -> {
                Vec3 lookVec = player.getLookAngle();
                Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
                int distance = this.maxdist;
                boolean gothrough = false;
                if (player.isShiftKeyDown()) {
                    distance /= 2;
                }
                Vec3 end = start.add(lookVec.x * (double)distance, lookVec.y * (double)distance, lookVec.z * (double)distance);
                ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
                BlockHitResult position = player.level().clip(context);
                this.safeTeleport(player, position);
            });
        }
    }

    private void safeTeleport(ServerPlayer player, BlockHitResult position) {
        Level level = player.level();
        BlockPos blockPos = position.getBlockPos();
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        if (level.isEmptyBlock(blockPos.above()) && level.isEmptyBlock(blockPos.above(2))) {
            player.teleportTo((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        } else {
            switch (position.getDirection()) {
                case DOWN: {
                    player.teleportTo((double)x + 0.5, (double)(y - 2), (double)z + 0.5);
                    break;
                }
                case UP: {
                    return;
                }
                case NORTH: {
                    player.teleportTo((double)x + 0.5, (double)y, (double)(z - 1) + 0.5);
                    break;
                }
                case SOUTH: {
                    player.teleportTo((double)x + 0.5, (double)y, (double)(z + 1) + 0.5);
                    break;
                }
                case WEST: {
                    player.teleportTo((double)(x - 1) + 0.5, (double)y, (double)z + 0.5);
                    break;
                }
                case EAST: {
                    player.teleportTo((double)(x + 1) + 0.5, (double)y, (double)z + 0.5);
                }
            }
        }
        SoundTools.playSound((Level)player.getCommandSenderWorld(), (SoundEvent)SoundEvents.ENDER_PEARL_THROW, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)1.0, (double)1.0);
    }

    public record Params(int maxdist) implements IEffectParameters
    {
        @Override
        public EffectDescription.EffectType getType() {
            return EffectDescription.EffectType.WARP;
        }

        public static Params cast(IEffectParameters params) {
            if (params instanceof Params) {
                Params p = (Params)params;
                return p;
            }
            throw new RuntimeException("Bad parameter type!");
        }
    }
}

