/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import mcjty.lib.varia.Tools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EssenceLootModifier
extends LootModifier {
    private final ResourceLocation item;
    private final float chance;
    private final int min;
    private final int max;
    private final float lootingFactor;
    public static final MapCodec<EssenceLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(l -> l.conditions), (App)ResourceLocation.CODEC.fieldOf("item").forGetter(l -> l.item), (App)Codec.FLOAT.fieldOf("chance").forGetter(l -> Float.valueOf(l.chance)), (App)Codec.INT.fieldOf("min").forGetter(l -> l.min), (App)Codec.INT.fieldOf("max").forGetter(l -> l.max), (App)Codec.FLOAT.fieldOf("looting").forGetter(l -> Float.valueOf(l.lootingFactor))).apply((Applicative)instance, EssenceLootModifier::new));

    public EssenceLootModifier(LootItemCondition[] conditionsIn, ResourceLocation item, float chance, int min, int max, float looting) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.lootingFactor = looting;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Item it = Tools.getItem((ResourceLocation)this.item);
        if (it == null) {
            return generatedLoot;
        }
        RandomSource random = context.getRandom();
        if (random.nextFloat() < this.chance + context.getLuck() * this.lootingFactor) {
            int cnt = this.max <= this.min ? this.min : random.nextInt(this.max - this.min + 1) + this.min;
            cnt += random.nextInt((int)(context.getLuck() + 1.0f));
            while (cnt > 0) {
                generatedLoot.add((Object)new ItemStack((ItemLike)it));
                --cnt;
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

