/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.mcjty.fancytrinkets.FancyTrinkets;
import com.mcjty.fancytrinkets.modules.loot.EssenceLootModifier;
import com.mcjty.fancytrinkets.modules.loot.TrinketLootModifier;
import com.mcjty.fancytrinkets.setup.Registration;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.registries.DeferredItem;

public class LootModule
implements IModule {
    public static final Map<String, Essence> ESSENCE_ITEMS = new HashMap<String, Essence>();
    public static final Map<String, EssenceGLM> ESSENCE_GLMS = new HashMap<String, EssenceGLM>();
    public static final DeferredItem<Item> ZOMBIE_ESSENCE = LootModule.createBasicItem("zombie_essence", "item/essence/zombie_essence", "Zombie Essence");
    public static final DeferredItem<Item> WITHER_SKELETON_ESSENCE = LootModule.createBasicItem("wither_skeleton_essence", "item/essence/wither_skeleton_essence", "Wither Skeleton Essence");
    public static final DeferredItem<Item> WITHER_ESSENCE = LootModule.createBasicItem("wither_essence", "item/essence/wither_essence", "Wither Essence");
    public static final DeferredItem<Item> SKELETON_ESSENCE = LootModule.createBasicItem("skeleton_essence", "item/essence/skeleton_essence", "Skeleton Essence");
    public static final DeferredItem<Item> DRAGON_ESSENCE = LootModule.createBasicItem("dragon_essence", "item/essence/dragon_essence", "Enderdragon Essence");
    public static final DeferredItem<Item> ENDERMAN_ESSENCE = LootModule.createBasicItem("enderman_essence", "item/essence/enderman_essence", "Enderman Essence");
    public static final DeferredItem<Item> GHAST_ESSENCE = LootModule.createBasicItem("ghast_essence", "item/essence/ghast_essence", "Ghast Essence");
    public static final DeferredItem<Item> SPIDER_ESSENCE = LootModule.createBasicItem("spider_essence", "item/essence/spider_essence", "Spider Essence");
    public static final DeferredItem<Item> CHICKEN_ESSENCE = LootModule.createBasicItem("chicken_essence", "item/essence/chicken_essence", "Chicken Essence");
    public static final DeferredItem<Item> IRON_GOLEM_ESSENCE = LootModule.createBasicItem("iron_golem_essence", "item/essence/iron_golem_essence", "Iron Golem Essence");
    public static final DeferredItem<Item> BLAZE_ESSENCE = LootModule.createBasicItem("blaze_essence", "item/essence/blaze_essence", "Blaze Essence");
    public static final Supplier<MapCodec<? extends IGlobalLootModifier>> ESSENCE_LOOT_MODIFIER = Registration.LOOT_MODIFIER_SERIALIZERS.register("essence_loot", () -> EssenceLootModifier.CODEC);
    public static final Supplier<MapCodec<? extends IGlobalLootModifier>> TRINKET_LOOT_MODIFIER = Registration.LOOT_MODIFIER_SERIALIZERS.register("trinket_loot", () -> TrinketLootModifier.CODEC);
    public static final EssenceGLM ZOMBIE_LOOT_MODIFIER = LootModule.createGlm("zombie_essence", EntityType.ZOMBIE, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM WITHER_SKELETON_LOOT_MODIFIER = LootModule.createGlm("wither_skeleton_essence", EntityType.WITHER_SKELETON, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM WITHER_LOOT_MODIFIER = LootModule.createGlm("wither_essence", EntityType.WITHER, 1.0f, 1, 2, 0.3f);
    public static final EssenceGLM SKELETON_LOOT_MODIFIER = LootModule.createGlm("skeleton_essence", EntityType.SKELETON, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM DRAGON_LOOT_MODIFIER = LootModule.createGlm("dragon_essence", EntityType.ENDER_DRAGON, 1.0f, 4, 7, 0.3f);
    public static final EssenceGLM ENDERMAN_LOOT_MODIFIER = LootModule.createGlm("enderman_essence", EntityType.ENDERMAN, 0.1f, 1, 2, 0.3f);
    public static final EssenceGLM GHAST_LOOT_MODIFIER = LootModule.createGlm("ghast_essence", EntityType.GHAST, 0.4f, 1, 2, 0.3f);
    public static final EssenceGLM SPIDER_LOOT_MODIFIER = LootModule.createGlm("spider_essence", EntityType.SPIDER, 0.1f, 1, 1, 0.3f);
    public static final EssenceGLM CHICKEN_LOOT_MODIFIER = LootModule.createGlm("chicken_essence", EntityType.CHICKEN, 0.1f, 1, 1, 0.3f);
    public static final EssenceGLM IRON_GOLEM_LOOT_MODIFIER = LootModule.createGlm("iron_golem_essence", EntityType.IRON_GOLEM, 0.3f, 1, 2, 0.3f);
    public static final EssenceGLM BLAZE_LOOT_MODIFIER = LootModule.createGlm("blaze_essence", EntityType.BLAZE, 0.3f, 1, 2, 0.3f);

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void initConfig(IEventBus bus) {
    }

    /*
     * WARNING - void declaration
     */
    public void initDatagen(DataGen dataGen, HolderLookup.Provider lookupProvider) {
        void var7_15;
        ResourceLocation[] resourceLocationArray;
        ResourceLocation[] goodChests;
        for (Map.Entry<String, Essence> entry : ESSENCE_ITEMS.entrySet()) {
            Essence essence = entry.getValue();
            dataGen.add(new Dob.Builder[]{Dob.itemBuilder(essence.item()).name(essence.description()).generatedItem(essence.texture())});
        }
        for (Map.Entry<String, Record> entry : ESSENCE_GLMS.entrySet()) {
            EssenceGLM glm = (EssenceGLM)entry.getValue();
            dataGen.add(new Dob.Builder[]{Dob.builder().glm(entry.getKey(), () -> new EssenceLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)glm.lootTable()).build(), LootItemKilledByPlayerCondition.killedByPlayer().build()}, glm.itemId(), glm.chance(), glm.min(), glm.max(), glm.looting()))});
        }
        dataGen.add(new Dob.Builder[]{Dob.builder().glm("wither_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)EntityType.WITHER.getDefaultLootTable().location()).build()}, List.of(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)"regeneration_ring")), 0.5f, 1, 1, 0.0f, 60.0f, 70.0f)).glm("dragon_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)EntityType.ENDER_DRAGON.getDefaultLootTable().location()).build()}, List.of(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)"power_star")), 1.0f, 1, 1, 0.0f, 90.0f, 100.0f)).glm("enderman_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)EntityType.ENDERMAN.getDefaultLootTable().location()).build()}, List.of(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)"warp_pearl")), 0.02f, 1, 1, 0.0f, 90.0f, 100.0f))});
        for (ResourceLocation resourceLocation : goodChests = new ResourceLocation[]{BuiltInLootTables.END_CITY_TREASURE.location(), BuiltInLootTables.STRONGHOLD_LIBRARY.location(), BuiltInLootTables.DESERT_PYRAMID.location(), BuiltInLootTables.WOODLAND_MANSION.location(), BuiltInLootTables.BASTION_TREASURE.location(), BuiltInLootTables.ANCIENT_CITY.location()}) {
            dataGen.add(new Dob.Builder[]{Dob.builder().glm(resourceLocation.getPath() + "_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)chest).build()}, Collections.emptyList(), 0.1f, 1, 1, 0.0f, 20.0f, 70.0f))});
        }
        ResourceLocation[] resourceLocationArray2 = resourceLocationArray = new ResourceLocation[]{BuiltInLootTables.SIMPLE_DUNGEON.location(), BuiltInLootTables.VILLAGE_CARTOGRAPHER.location(), BuiltInLootTables.VILLAGE_TEMPLE.location(), BuiltInLootTables.ABANDONED_MINESHAFT.location(), BuiltInLootTables.NETHER_BRIDGE.location(), BuiltInLootTables.STRONGHOLD_CROSSING.location(), BuiltInLootTables.STRONGHOLD_CORRIDOR.location(), BuiltInLootTables.JUNGLE_TEMPLE.location(), BuiltInLootTables.JUNGLE_TEMPLE_DISPENSER.location(), BuiltInLootTables.IGLOO_CHEST.location(), BuiltInLootTables.UNDERWATER_RUIN_SMALL.location(), BuiltInLootTables.UNDERWATER_RUIN_BIG.location(), BuiltInLootTables.BURIED_TREASURE.location(), BuiltInLootTables.SHIPWRECK_MAP.location(), BuiltInLootTables.SHIPWRECK_SUPPLY.location(), BuiltInLootTables.SHIPWRECK_TREASURE.location(), BuiltInLootTables.PILLAGER_OUTPOST.location(), BuiltInLootTables.BASTION_OTHER.location(), BuiltInLootTables.BASTION_BRIDGE.location(), BuiltInLootTables.BASTION_HOGLIN_STABLE.location(), BuiltInLootTables.ANCIENT_CITY_ICE_BOX.location(), BuiltInLootTables.RUINED_PORTAL.location()};
        int n = resourceLocationArray2.length;
        boolean bl = false;
        while (var7_15 < n) {
            ResourceLocation chest = resourceLocationArray2[var7_15];
            dataGen.add(new Dob.Builder[]{Dob.builder().glm(chest.getPath() + "_trinket", () -> new TrinketLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)chest).build()}, Collections.emptyList(), 0.02f, 1, 1, 0.0f, 5.0f, 10.0f))});
            ++var7_15;
        }
    }

    @Nonnull
    private static DeferredItem<Item> createBasicItem(String id, String texture, String description) {
        DeferredItem object = Registration.ITEMS.register(id, FancyTrinkets.tab(() -> new Item(FancyTrinkets.setup.defaultProperties().stacksTo(64))));
        ESSENCE_ITEMS.put(id, new Essence((DeferredItem<Item>)object, texture, description));
        return object;
    }

    private static EssenceGLM createGlm(String id, EntityType<?> type, float chance, int min, int max, float looting) {
        EssenceGLM glm = new EssenceGLM(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)id), type.getDefaultLootTable().location(), chance, min, max, looting);
        ESSENCE_GLMS.put(id, glm);
        return glm;
    }

    public record Essence(DeferredItem<Item> item, String texture, String description) {
    }

    public record EssenceGLM(ResourceLocation itemId, ResourceLocation lootTable, float chance, int min, int max, float looting) {
    }
}

