/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.loot;

import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.datapack.TrinketDescription;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mcjty.lib.varia.Tools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class TrinketLootModifier
extends LootModifier {
    private final List<ResourceLocation> trinketIds;
    private final float chance;
    private final int min;
    private final int max;
    private final float lootingFactor;
    private final float minQuality;
    private final float maxQuality;
    public static final MapCodec<TrinketLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(l -> l.conditions), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("trinkets").forGetter(l -> l.trinketIds), (App)Codec.FLOAT.fieldOf("chance").forGetter(l -> Float.valueOf(l.chance)), (App)Codec.INT.fieldOf("min").forGetter(l -> l.min), (App)Codec.INT.fieldOf("max").forGetter(l -> l.max), (App)Codec.FLOAT.fieldOf("looting").forGetter(l -> Float.valueOf(l.lootingFactor)), (App)Codec.FLOAT.fieldOf("minquality").forGetter(l -> Float.valueOf(l.minQuality)), (App)Codec.FLOAT.fieldOf("maxquality").forGetter(l -> Float.valueOf(l.maxQuality))).apply((Applicative)instance, TrinketLootModifier::new));

    public TrinketLootModifier(LootItemCondition[] conditionsIn, List<ResourceLocation> trinketIds, float chance, int min, int max, float looting, float minQuality, float maxQuality) {
        super(conditionsIn);
        this.trinketIds = trinketIds;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.lootingFactor = looting;
        this.minQuality = minQuality;
        this.maxQuality = maxQuality;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation id;
        RandomSource random = context.getRandom();
        if (this.trinketIds.isEmpty()) {
            List<ResourceLocation> keys = Tools.getRegistryAccess((Level)context.getLevel()).registryOrThrow(CustomRegistries.TRINKET_REGISTRY_KEY).entrySet().stream().map(p -> ((ResourceKey)p.getKey()).location()).toList();
            if (keys.isEmpty()) {
                return generatedLoot;
            }
            id = keys.get(random.nextInt(keys.size()));
        } else {
            id = this.trinketIds.get(random.nextInt(this.trinketIds.size()));
        }
        TrinketDescription trinket = (TrinketDescription)Tools.getRegistryAccess((Level)context.getLevel()).registryOrThrow(CustomRegistries.TRINKET_REGISTRY_KEY).get(id);
        if (trinket == null) {
            return generatedLoot;
        }
        Item it = Tools.getItem((ResourceLocation)trinket.item());
        if (it == null) {
            return generatedLoot;
        }
        if (random.nextFloat() < this.chance + context.getLuck() * this.lootingFactor) {
            int cnt = this.max <= this.min ? this.min : random.nextInt(this.max - this.min + 1) + this.min;
            cnt += random.nextInt((int)(context.getLuck() + 1.0f));
            while (cnt > 0) {
                ItemStack stack = TrinketItem.createTrinketStack((Level)context.getLevel(), trinket, id, random.nextFloat() * (this.maxQuality - this.minQuality) + this.minQuality);
                generatedLoot.add((Object)stack);
                --cnt;
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

