/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.trinkets;

import com.mcjty.fancytrinkets.FancyTrinkets;
import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.datapack.BonusTable;
import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.datapack.TrinketDescription;
import com.mcjty.fancytrinkets.datapack.TrinketSet;
import com.mcjty.fancytrinkets.modules.loot.LootModule;
import com.mcjty.fancytrinkets.modules.trinkets.DefaultBonusTables;
import com.mcjty.fancytrinkets.modules.trinkets.DefaultTrinkets;
import com.mcjty.fancytrinkets.modules.trinkets.data.TrinketData;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItem;
import com.mcjty.fancytrinkets.modules.xpcrafter.recipe.XpRecipeBuilder;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.varia.Tools;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosTags;

public class TrinketsModule
implements IModule {
    public static final Map<ResourceLocation, TrinketInfo> TRINKET_ITEMS = new HashMap<ResourceLocation, TrinketInfo>();
    public static final DeferredItem<TrinketItem> GOLD_RING = TrinketsModule.trinket("gold_ring", "item/gold_ring", "Base golden ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> GOLD_RING_BLUE = TrinketsModule.trinket("gold_ring_blue", "item/gold_ring_blue", "Base golden ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> GOLD_RING_GREEN = TrinketsModule.trinket("gold_ring_green", "item/gold_ring_green", "Base golden ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> GOLD_RING_RED = TrinketsModule.trinket("gold_ring_red", "item/gold_ring_red", "Base golden ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> GOLD_RING_DIAMOND = TrinketsModule.trinket("gold_ring_diamond", "item/gold_ring_diamond", "Base golden ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> SILVER_RING = TrinketsModule.trinket("silver_ring", "item/silver_ring", "Base silver ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> SILVER_RING_BLUE = TrinketsModule.trinket("silver_ring_blue", "item/silver_ring_blue", "Base silver ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> SILVER_RING_GREEN = TrinketsModule.trinket("silver_ring_green", "item/silver_ring_green", "Base silver ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> SILVER_RING_RED = TrinketsModule.trinket("silver_ring_red", "item/silver_ring_red", "Base silver ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> SILVER_RING_DIAMOND = TrinketsModule.trinket("silver_ring_diamond", "item/silver_ring_diamond", "Base silver ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> OBSIDIAN_RING = TrinketsModule.trinket("obsidian_ring", "item/obsidian_ring", "Base obsidian ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> OBSIDIAN_RING_DIAMOND = TrinketsModule.trinket("obsidian_ring_diamond", "item/obsidian_ring_diamond", "Base obsidian ring item", CuriosTags.RING);
    public static final DeferredItem<TrinketItem> STAR = TrinketsModule.trinket("star", "item/star", "Base star item", CuriosTags.RING, CuriosTags.BELT, CuriosTags.BRACELET, CuriosTags.CHARM, CuriosTags.NECKLACE, CuriosTags.HEAD, CuriosTags.BODY);
    public static final DeferredItem<TrinketItem> HEART = TrinketsModule.trinket("heart", "item/heart", "Base heart item", CuriosTags.RING, CuriosTags.BELT, CuriosTags.BRACELET, CuriosTags.CHARM, CuriosTags.NECKLACE, CuriosTags.HEAD, CuriosTags.BODY);
    public static final DeferredItem<TrinketItem> HEART_BODY = TrinketsModule.trinket("heart_body", "item/heart", "Base heart item (body)", CuriosTags.BODY);
    public static final DeferredItem<TrinketItem> FEATHER = TrinketsModule.trinket("feather", "item/feather", "Feather star item", CuriosTags.BELT, CuriosTags.CHARM, CuriosTags.NECKLACE, CuriosTags.HEAD, CuriosTags.BODY);
    public static final DeferredItem<TrinketItem> BLACK_PEARL = TrinketsModule.trinket("black_pearl", "item/black_pearl", "Black pearl", CuriosTags.CHARM);
    public static final DeferredItem<TrinketItem> BLUE_PEARL = TrinketsModule.trinket("blue_pearl", "item/blue_pearl", "Blue pearl", CuriosTags.CHARM);
    public static final DeferredItem<TrinketItem> YELLOW_PEARL = TrinketsModule.trinket("yellow_pearl", "item/yellow_pearl", "Yellow pearl", CuriosTags.CHARM);
    public static final DeferredItem<TrinketItem> PURPLE_PEARL = TrinketsModule.trinket("purple_pearl", "item/purple_pearl", "Purple pearl", CuriosTags.CHARM);
    public static final DeferredItem<TrinketItem> SHINY_PEARL = TrinketsModule.trinket("shiny_pearl", "item/shiny_pearl", "Shiny pearl", CuriosTags.CHARM);
    public static final DeferredItem<TrinketItem> LEATHER_BELT = TrinketsModule.trinket("leather_belt", "item/leather_belt", "Leather Belt", CuriosTags.BELT);
    public static final DeferredItem<TrinketItem> BLUE_BELT = TrinketsModule.trinket("blue_belt", "item/blue_belt", "Blue Belt", CuriosTags.BELT);
    public static final DeferredItem<TrinketItem> CHARM1 = TrinketsModule.trinket("charm1", "item/charm1", "Charm", CuriosTags.CHARM);
    public static final DeferredItem<TrinketItem> CHARM2 = TrinketsModule.trinket("charm2", "item/charm2", "Charm", CuriosTags.CHARM);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<TrinketData>> TRINKET_DATA = Registration.COMPONENTS.registerComponentType("trinket_data", builder -> builder.persistent(TrinketData.CODEC).networkSynchronized(TrinketData.STREAM_CODEC));

    public TrinketsModule(IEventBus bus) {
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        DefaultTrinkets.init();
        DefaultBonusTables.init();
    }

    public static DeferredItem<TrinketItem> trinket(String id, String texture, String description, TagKey ... tags) {
        DeferredItem object = Registration.ITEMS.register(id, FancyTrinkets.tab(TrinketItem::new));
        TRINKET_ITEMS.put(object.getId(), new TrinketInfo(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)id), texture, description, (DeferredItem<TrinketItem>)object, tags));
        return object;
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void onServerStarting(ServerStartingEvent event) {
        TrinketsModule.registerTrinkets((Level)event.getServer().overworld());
    }

    public static void registerTrinkets(Level level) {
        Registry registry = Tools.getRegistryAccess((Level)level).registryOrThrow(CustomRegistries.TRINKET_REGISTRY_KEY);
        for (ResourceLocation trinket : ((TrinketSet)Tools.getRegistryAccess((Level)level).registryOrThrow(CustomRegistries.TRINKET_SET_REGISTRY_KEY).get(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)"standard"))).trinkets()) {
            TrinketDescription description = (TrinketDescription)registry.get(trinket);
            ResourceLocation itemId = description.item();
            Item item = Tools.getItem((ResourceLocation)itemId);
            if (item == null || item == Items.AIR) {
                throw new RuntimeException("Can't find item '" + itemId.toString() + "'!");
            }
            if (item instanceof ITrinketItem) {
                ITrinketItem trinketItem = (ITrinketItem)item;
                trinketItem.registerTrinketInstance(level, trinket, description);
                continue;
            }
            throw new RuntimeException("Item '" + itemId.toString() + "' is not an ITrinketItem!");
        }
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void initConfig(IEventBus bus) {
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider lookupProvider) {
        dataGen.addCodecProvider("bonus", "fancytrinkets/bonustables", BonusTable.CODEC);
        dataGen.addCodecProvider("trinkets", "fancytrinkets/trinkets", TrinketDescription.CODEC);
        dataGen.addCodecProvider("trinketsets", "fancytrinkets/trinketsets", TrinketSet.CODEC);
        dataGen.add(new Dob.Builder[]{Dob.builder().holderLookup("bonus", lookupProvider).codecObjectSupplier("bonus", () -> DefaultBonusTables.DEFAULT_BONUS_TABLES.entrySet().stream().map(entry -> Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((DefaultBonusTables.BonusTableInfo)entry.getValue()).bonusTable())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight))), Dob.builder().holderLookup("trinkets", lookupProvider).codecObjectSupplier("trinkets", () -> DefaultTrinkets.DEFAULT_TRINKETS.entrySet().stream().map(entry -> Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((DefaultTrinkets.TrinketInfo)entry.getValue()).trinketDescription())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight))), Dob.builder().holderLookup("trinketsets", lookupProvider).codecObjectSupplier("trinketsets", () -> {
            ArrayList<ResourceLocation> trinkets = new ArrayList<ResourceLocation>(DefaultTrinkets.DEFAULT_TRINKETS.keySet());
            return Map.of(ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)"standard"), new TrinketSet(trinkets));
        })});
        for (Map.Entry<ResourceLocation, TrinketInfo> entry : TRINKET_ITEMS.entrySet()) {
            TrinketInfo trinket = entry.getValue();
            dataGen.add(new Dob.Builder[]{Dob.itemBuilder(trinket.item()).name(trinket.description()).generatedItem(trinket.texture()).itemTags(List.of(trinket.tags()))});
        }
        dataGen.add(new Dob.Builder[]{Dob.builder().recipeConsumer(() -> consumer -> {
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("base_star")).define(Character.valueOf('g'), Tags.Items.GEMS_PRISMARINE).patternLine("g g g").patternLine("  g  ").patternLine("ggggg").patternLine("  g  ").patternLine("g g g").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("base_star"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("flight_star")).define(Character.valueOf('f'), Tags.Items.FEATHERS).define(Character.valueOf('t'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('g'), (ItemLike)LootModule.GHAST_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_star")).patternLine("gfgfg").patternLine("fgtgf").patternLine("gtStg").patternLine("fgtgf").patternLine("gfgfg").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("flight_star"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("flight_star")).define(Character.valueOf('g'), (ItemLike)LootModule.GHAST_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("flight_star")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("flight_star_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("power_star")).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('t'), (ItemLike)Items.DRAGON_HEAD).define(Character.valueOf('g'), (ItemLike)LootModule.DRAGON_ESSENCE.get()).define(Character.valueOf('w'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_star")).patternLine(" iii ").patternLine("iwtwi").patternLine("igSgi").patternLine("iwgwi").patternLine(" iii ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("power_star"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("power_star")).define(Character.valueOf('g'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("power_star")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("power_star_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("swift_star")).define(Character.valueOf('t'), Tags.Items.GEMS_QUARTZ).define(Character.valueOf('g'), (ItemLike)LootModule.SPIDER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_star")).patternLine("ttgtt").patternLine("tgggt").patternLine("ggSgg").patternLine("tgggt").patternLine("ttgtt").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("swift_star"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("swift_star")).define(Character.valueOf('g'), (ItemLike)LootModule.SPIDER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("swift_star")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("swift_star_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("grow_charm")).define(Character.valueOf('f'), Tags.Items.BONES).define(Character.valueOf('t'), (ItemLike)Items.BONE_MEAL).define(Character.valueOf('w'), (ItemLike)Items.DIAMOND_BLOCK).define(Character.valueOf('g'), (ItemLike)LootModule.SKELETON_ESSENCE.get()).patternLine(" fwf ").patternLine("fgggf").patternLine("tgggt").patternLine("fgggf").patternLine(" fwf ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("grow_charm"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("grow_charm")).define(Character.valueOf('g'), (ItemLike)LootModule.SKELETON_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("grow_charm")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("grow_charm_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("slowfalling_feather")).define(Character.valueOf('o'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('f'), Tags.Items.FEATHERS).define(Character.valueOf('g'), (ItemLike)LootModule.CHICKEN_ESSENCE.get()).patternLine("ooofg").patternLine("oofgg").patternLine("ogggo").patternLine("fggoo").patternLine("gfooo").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("slowfalling_feather"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("slowfalling_feather")).define(Character.valueOf('g'), (ItemLike)LootModule.CHICKEN_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("slowfalling_feather")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("slowfalling_feather_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("base_gold_ring")).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).patternLine(" ggg ").patternLine("g   g").patternLine("g   g").patternLine("g   g").patternLine(" ggg ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("base_gold_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("lightness_ring")).define(Character.valueOf('t'), (ItemLike)Items.DIAMOND_BLOCK).define(Character.valueOf('w'), (ItemLike)Items.AMETHYST_BLOCK).define(Character.valueOf('f'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.CHICKEN_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring")).patternLine(" wtw ").patternLine("wfgfw").patternLine("tgSgt").patternLine("wfgfw").patternLine(" wtw ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("lightness_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("lightness_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.CHICKEN_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("lightness_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("lightness_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("fireresist_ring")).define(Character.valueOf('t'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('f'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.BLAZE_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring")).patternLine("gfgfg").patternLine("ftgtf").patternLine("ggSgg").patternLine("ftgtf").patternLine("gfgfg").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("fireresist_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("fireresist_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.BLAZE_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("fireresist_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("fireresist_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("nightvision_ring")).define(Character.valueOf('t'), (ItemLike)Items.SPIDER_EYE).define(Character.valueOf('w'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('f'), (ItemLike)Items.FERMENTED_SPIDER_EYE).define(Character.valueOf('g'), (ItemLike)LootModule.SPIDER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring")).patternLine("tfwft").patternLine("wtgfw").patternLine("wgSgt").patternLine("fwgtf").patternLine("twfwf").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("nightvision_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("nightvision_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.SPIDER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("nightvision_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("nightvision_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("stepassist_ring")).define(Character.valueOf('t'), ItemTags.STAIRS).define(Character.valueOf('w'), ItemTags.WOODEN_STAIRS).define(Character.valueOf('g'), (ItemLike)LootModule.SPIDER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring")).patternLine("twtwt").patternLine("wtgtw").patternLine("tgSgt").patternLine("wtgtw").patternLine("twtwt").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("stepassist_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("stepassist_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.SPIDER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("stepassist_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("stepassist_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("base_heart")).define(Character.valueOf('g'), (ItemLike)Items.REDSTONE_BLOCK).patternLine(" ggg ").patternLine("ggggg").patternLine("ggggg").patternLine(" ggg ").patternLine("  g  ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("base_heart"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("super_health")).define(Character.valueOf('t'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('w'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('f'), (ItemLike)LootModule.ENDERMAN_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_heart")).patternLine("tffft").patternLine("fgwgf").patternLine("fgSgf").patternLine("fgwgf").patternLine("tffft").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("super_health"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("super_health")).define(Character.valueOf('g'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("super_health")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("super_health_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("cure")).define(Character.valueOf('t'), (ItemLike)Items.END_CRYSTAL).define(Character.valueOf('w'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('f'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.ENDERMAN_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_heart")).patternLine("tffft").patternLine("fgwgf").patternLine("fgSgf").patternLine("fgwgf").patternLine("tffft").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("cure"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("cure")).define(Character.valueOf('g'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("cure")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("cure_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("base_gold_ring_diamond")).define(Character.valueOf('d'), (ItemLike)Items.DIAMOND).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).patternLine(" gdg ").patternLine("g   g").patternLine("g   g").patternLine("g   g").patternLine(" ggg ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("base_gold_ring_diamond"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("absorption_ring")).define(Character.valueOf('t'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('f'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring_diamond")).patternLine("gfgfg").patternLine("ftgtf").patternLine("ggSgg").patternLine("ftgtf").patternLine("gfgfg").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("absorption_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("absorption_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("absorption_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("absorption_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("regeneration_ring")).define(Character.valueOf('t'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('w'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.ZOMBIE_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring_diamond")).patternLine("ggggg").patternLine("gwtwg").patternLine("gtStg").patternLine("gwtwg").patternLine("ggggg").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("regeneration_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("regeneration_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("regeneration_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("regeneration_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("strength_ring")).define(Character.valueOf('t'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('I'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('w'), (ItemLike)LootModule.WITHER_ESSENCE.get()).define(Character.valueOf('g'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("base_gold_ring_diamond")).patternLine("IgggI").patternLine("gwtwg").patternLine("gtStg").patternLine("gwtwg").patternLine("IgggI").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("strength_ring"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("strength_ring")).define(Character.valueOf('g'), (ItemLike)LootModule.IRON_GOLEM_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("strength_ring")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("strength_ring_reforge"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("warp_pearl")).define(Character.valueOf('o'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('g'), (ItemLike)LootModule.ENDERMAN_ESSENCE.get()).patternLine(" ooo ").patternLine("ogggo").patternLine("ogggo").patternLine("ogggo").patternLine(" ooo ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("warp_pearl"));
            XpRecipeBuilder.shapedRecipe(this.createTrinketStack("warp_pearl")).define(Character.valueOf('g'), (ItemLike)LootModule.ENDERMAN_ESSENCE.get()).define(Character.valueOf('S'), this.createTrinketIngredient("warp_pearl")).patternLine("     ").patternLine(" ggg ").patternLine(" gSg ").patternLine(" ggg ").patternLine("     ").unlockedBy("trinket", (Criterion<? extends CriterionTriggerInstance>)Dob.has((ItemLike)Items.GOLD_INGOT)).build((RecipeOutput)consumer, this.trinket("warp_pearl_reforge"));
        })});
    }

    private ResourceLocation trinket(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"fancytrinkets", (String)id);
    }

    private ItemStack createTrinketStack(String id) {
        ResourceLocation trinkedId = this.trinket(id);
        return TrinketItem.createTrinketStack(DefaultTrinkets.DEFAULT_TRINKETS.get(trinkedId).trinketDescription(), trinkedId);
    }

    @NotNull
    private Ingredient createTrinketIngredient(String id) {
        ItemStack stack = this.createTrinketStack(id);
        return Ingredient.of((ItemStack[])new ItemStack[]{stack});
    }

    public record TrinketInfo(ResourceLocation id, String texture, String description, DeferredItem<TrinketItem> item, TagKey<Item>[] tags) {
    }
}

