/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.trinkets.items;

import com.mcjty.fancytrinkets.FancyTrinkets;
import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.datapack.BonusTable;
import com.mcjty.fancytrinkets.datapack.CustomRegistries;
import com.mcjty.fancytrinkets.datapack.EffectDescription;
import com.mcjty.fancytrinkets.datapack.TrinketDescription;
import com.mcjty.fancytrinkets.keys.KeyBindings;
import com.mcjty.fancytrinkets.modules.effects.EffectInstance;
import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketInstance;
import com.mcjty.fancytrinkets.modules.trinkets.TrinketsModule;
import com.mcjty.fancytrinkets.modules.trinkets.data.TrinketData;
import com.mcjty.fancytrinkets.setup.Config;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mcjty.lib.items.BaseItem;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SafeClientTools;
import mcjty.lib.varia.Tools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TrinketItem
extends BaseItem
implements ITooltipSettings,
ITrinketItem {
    public static final String MESSAGE_FANCYTRINKETS_SHIFTMESSAGE = "message.fancytrinkets.shiftmessage";
    public static final String MESSAGE_FANCYTRINKETS_BONUS = "message.fancytrinkets.bonus";
    private static final Random random = new Random();
    private final Map<ResourceLocation, TrinketInstance> trinkets = new HashMap<ResourceLocation, TrinketInstance>();
    public static Set<String> toggles = new HashSet<String>();

    public TrinketItem() {
        super(FancyTrinkets.setup.defaultProperties().stacksTo(1));
    }

    public static boolean addBonusEffects(Level level, ITrinketItem trinket, ItemStack stack, float targetQuality) {
        BonusTable bonusTable;
        ResourceLocation bonusTableId;
        ResourceLocation id = trinket.getTrinketId(stack);
        TrinketDescription description = (TrinketDescription)Tools.getRegistryAccess((Level)level).registryOrThrow(CustomRegistries.TRINKET_REGISTRY_KEY).get(id);
        if (description != null && (bonusTableId = description.bonusTableId()) != null && (bonusTable = (BonusTable)Tools.getRegistryAccess((Level)level).registryOrThrow(CustomRegistries.BONUS_TABLE_REGISTRY_KEY).get(bonusTableId)) != null) {
            ArrayList<ResourceLocation> effects = new ArrayList<ResourceLocation>();
            List<BonusTable.EffectRef> list = Collections.emptyList();
            float maxDiff = 10.0f;
            while (list.size() < 9) {
                list = TrinketItem.findSuitableEffects(bonusTable.effects(), targetQuality, maxDiff);
                maxDiff += 5.0f;
            }
            if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT1.get()) {
                TrinketItem.addEffect(targetQuality, effects, list);
                if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT2.get()) {
                    TrinketItem.addEffect(targetQuality, effects, list);
                    if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT3.get()) {
                        TrinketItem.addEffect(targetQuality, effects, list);
                        if (random.nextDouble(100.0) <= (Double)Config.CHANCE_BONUS_EFFECT4.get()) {
                            TrinketItem.addEffect(targetQuality, effects, list);
                        }
                    }
                }
            }
            trinket.addEffects(stack, effects);
            return true;
        }
        return false;
    }

    private static List<BonusTable.EffectRef> findSuitableEffects(List<BonusTable.EffectRef> list, float desiredQuality, float maxDiff) {
        return list.stream().filter(ref -> Math.abs(ref.quality() - desiredQuality) <= maxDiff).collect(Collectors.toList());
    }

    private static void addEffect(float targetQuality, List<ResourceLocation> effects, List<BonusTable.EffectRef> list) {
        int bestIndex = -1;
        float bestDiff = Float.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            BonusTable.EffectRef ref = list.get(random.nextInt(list.size()));
            float diff = Math.abs(ref.quality() - targetQuality);
            if (!(diff < bestDiff)) continue;
            bestDiff = diff;
            bestIndex = i;
        }
        ResourceLocation id = list.remove(bestIndex).effect();
        effects.add(id);
    }

    public List<ItemStack> getItemsForTab() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (TrinketInstance trinket : this.getTrinkets(SafeClientTools.getClientWorld()).values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(TrinketsModule.TRINKET_DATA, (Object)new TrinketData(trinket.id(), Collections.emptyList()));
            list.add(stack);
        }
        return list;
    }

    @Override
    public void addEffects(ItemStack stack, List<ResourceLocation> effects) {
        TrinketData data = (TrinketData)stack.getOrDefault(TrinketsModule.TRINKET_DATA, (Object)TrinketData.DEFAULT);
        data = data.withEffects(effects);
        stack.set(TrinketsModule.TRINKET_DATA, (Object)data);
    }

    public static Stream<ResourceLocation> getEffects(ItemStack stack) {
        TrinketData data = (TrinketData)stack.getOrDefault(TrinketsModule.TRINKET_DATA, (Object)TrinketData.DEFAULT);
        return data.effects().stream();
    }

    public static ItemStack createTrinketStack(Level level, TrinketDescription description, ResourceLocation id, float quality) {
        ItemStack stack = TrinketItem.createTrinketStack(description, id);
        ITrinketItem trinket = (ITrinketItem)stack.getCapability(Registration.TRINKET_ITEM_CAPABILITY);
        if (trinket != null) {
            TrinketItem.addBonusEffects(level, trinket, stack, quality);
        }
        return stack;
    }

    @NotNull
    public static ItemStack createTrinketStack(TrinketDescription description, ResourceLocation id) {
        ResourceLocation itemId = description.item();
        Item item = Tools.getItem((ResourceLocation)itemId);
        if (item == null) {
            throw new RuntimeException("Cannot find item for trinket '" + id.toString() + "'!");
        }
        ItemStack result = new ItemStack((ItemLike)item);
        result.set(TrinketsModule.TRINKET_DATA, (Object)new TrinketData(id, Collections.emptyList()));
        return result;
    }

    @Override
    public ResourceLocation getTrinketId(ItemStack stack) {
        TrinketData data = (TrinketData)stack.getOrDefault(TrinketsModule.TRINKET_DATA, (Object)TrinketData.DEFAULT);
        return data.trinketId();
    }

    @Override
    public void registerTrinketInstance(Level level, ResourceLocation id, TrinketDescription description) {
        this.trinkets.put(id, description.build(id, level));
    }

    private Map<ResourceLocation, TrinketInstance> getTrinkets(Level level) {
        if (this.trinkets.isEmpty()) {
            TrinketsModule.registerTrinkets(level);
        }
        return this.trinkets;
    }

    @Override
    public void forAllEffects(Level level, ItemStack stack, BiConsumer<IEffect, Integer> consumer) {
        ResourceLocation trinketId = this.getTrinketId(stack);
        if (trinketId != null) {
            AtomicInteger idx = new AtomicInteger(0);
            TrinketInstance instance = this.getTrinkets(level).get(trinketId);
            if (instance != null) {
                for (EffectInstance effect2 : instance.effects()) {
                    consumer.accept(effect2.effect(), idx.incrementAndGet());
                }
            }
            Registry registry = Tools.getRegistryAccess((Level)level).registryOrThrow(CustomRegistries.EFFECT_REGISTRY_KEY);
            TrinketItem.getEffects(stack).forEach(effect -> {
                EffectDescription description = (EffectDescription)registry.get(effect);
                if (description != null) {
                    consumer.accept(description.effect(), idx.incrementAndGet());
                }
            });
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        TrinketInstance instance;
        ResourceLocation trinketId = this.getTrinketId(stack);
        if (trinketId != null && (instance = this.getTrinkets(context.level()).get(trinketId)) != null) {
            MutableComponent name = ComponentFactory.translatable((String)instance.nameKey()).withStyle(ChatFormatting.AQUA);
            if (list.isEmpty()) {
                list.add((Component)name);
            } else {
                list.set(0, (Component)name);
            }
            list.add((Component)ComponentFactory.translatable((String)instance.descriptionKey()));
            for (EffectInstance effectInstance : instance.effects()) {
                Integer hotkey;
                IEffect effect2 = effectInstance.effect();
                if (effectInstance.hidden()) continue;
                MutableComponent translatable = ComponentFactory.translatable((String)("effectId." + effectInstance.id().getNamespace() + "." + effectInstance.id().getPath()));
                String toggle = effect2.getToggle();
                ChatFormatting color = ChatFormatting.BLUE;
                ChatFormatting style = ChatFormatting.BLUE;
                if (toggle != null && !toggles.contains(toggle)) {
                    color = ChatFormatting.GRAY;
                    style = ChatFormatting.STRIKETHROUGH;
                }
                if ((hotkey = effect2.getHotkey()) != null) {
                    Component key = KeyBindings.toggles[hotkey - 1].getKey().getDisplayName();
                    MutableComponent key2 = ComponentFactory.literal((String)" [Key ").withStyle(ChatFormatting.YELLOW).append(key).append("]");
                    list.add((Component)ComponentFactory.literal((String)"    ").append((Component)translatable.withStyle(color).withStyle(style).append((Component)key2)));
                    continue;
                }
                list.add((Component)ComponentFactory.literal((String)"    ").append((Component)translatable.withStyle(color).withStyle(style)));
            }
            AtomicBoolean first = new AtomicBoolean(true);
            TrinketItem.getEffects(stack).forEach(effect -> {
                if (first.get()) {
                    list.add((Component)ComponentFactory.translatable((String)MESSAGE_FANCYTRINKETS_BONUS).withStyle(ChatFormatting.AQUA));
                    first.set(false);
                }
                MutableComponent translatable = ComponentFactory.translatable((String)("effectId." + effect.getNamespace() + "." + effect.getPath()));
                ChatFormatting color = ChatFormatting.GREEN;
                EffectDescription description = (EffectDescription)Tools.getRegistryAccess((Level)SafeClientTools.getClientWorld()).registryOrThrow(CustomRegistries.EFFECT_REGISTRY_KEY).get(effect);
                if (description != null && description.harmful()) {
                    color = ChatFormatting.RED;
                }
                list.add((Component)ComponentFactory.literal((String)"    ").append((Component)translatable).withStyle(color));
            });
        }
    }

    @Nonnull
    public ICurio createCurio(final ItemStack itemStack) {
        return new ICurio(){

            public ItemStack getStack() {
                return itemStack;
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    String slotId = slotContext.identifier() + slotContext.index() + "_";
                    TrinketItem.this.forAllEffects(player.level(), itemStack, (effect, idx) -> effect.tick(itemStack, player, slotId + idx));
                }
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    String slotId = slotContext.identifier() + slotContext.index() + "_";
                    TrinketItem.this.forAllEffects(player.level(), itemStack, (effect, idx) -> effect.onEquip(itemStack, player, slotId + idx));
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    String slotId = slotContext.identifier() + slotContext.index() + "_";
                    TrinketItem.this.forAllEffects(player.level(), itemStack, (effect, idx) -> effect.onUnequip(itemStack, player, slotId + idx));
                }
            }
        };
    }
}

