/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.xpcrafter.blocks;

import com.mcjty.fancytrinkets.api.ITrinketItem;
import com.mcjty.fancytrinkets.modules.trinkets.items.TrinketItem;
import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import com.mcjty.fancytrinkets.modules.xpcrafter.data.ExperienceCrafterData;
import com.mcjty.fancytrinkets.modules.xpcrafter.recipe.XpRecipe;
import com.mcjty.fancytrinkets.setup.Config;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ExperienceCrafterBE
extends GenericTileEntity {
    public static final int SLOT_OUTPUT = 0;
    public static final int SLOT_PREVIEW = 1;
    public static final int SLOT_GRID = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(27).slot(SlotDefinition.generic().out(), 0, 151, 27).slot(SlotDefinition.ghostOut(), 1, 115, 27).box(SlotDefinition.generic().in(), 2, 10, 11, 5, 5).playerSlots(10, 110));
    @GuiValue
    public static final Value<?, Integer> VALUE_EXPERIENCE = Value.create((String)"experience", (Type)Type.INTEGER, ExperienceCrafterBE::getExperience, ExperienceCrafterBE::setExperience);
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).onUpdate(this::onUpdate).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<ExperienceCrafterBE, IItemHandler> ITEM_CAP = tile -> tile.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<ExperienceCrafterBE, MenuProvider> screenHandler = tile -> new DefaultContainerProvider("Experience Crafter").containerSupplier(DefaultContainerProvider.container(XpCrafterModule.CONTAINER_EXPERIENCE_CRAFTER, CONTAINER_FACTORY, (GenericTileEntity)tile)).itemHandler(() -> tile.items).setupSync((GenericTileEntity)tile);
    @ServerCommand
    public static final Command<?> CMD_FILLXP = Command.create((String)"fillxp", (te, player, params) -> te.fillExperience((ServerPlayer)player));
    @ServerCommand
    public static final Command<?> CMD_CRAFT = Command.create((String)"craft", (te, player, params) -> te.craft());
    private final CraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

        public boolean stillValid(@Nonnull Player playerIn) {
            return false;
        }

        public ItemStack quickMoveStack(Player player, int slot) {
            return ItemStack.EMPTY;
        }
    }, 5, 5);

    public ExperienceCrafterBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)XpCrafterModule.EXPERIENCE_CRAFTER.be().get(), pos, state);
    }

    private void craft() {
        Optional<RecipeHolder<XpRecipe>> result = this.findRecipe();
        result.ifPresent(recipe -> {
            CraftingInput input = CraftingInput.of((int)3, (int)3, (List)this.inv.getItems());
            ItemStack stack = ((XpRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)Tools.getRegistryAccess((Level)this.level));
            ItemStack outputSlot = this.items.getStackInSlot(0);
            if (outputSlot.isEmpty()) {
                ItemStack finalStack = stack = stack.copy();
                ITrinketItem trinket = (ITrinketItem)stack.getCapability(Registration.TRINKET_ITEM_CAPABILITY);
                if (trinket != null) {
                    this.addBonusEffects(trinket, finalStack);
                }
                this.items.setStackInSlot(0, stack);
                for (int x = 0; x < 5; ++x) {
                    for (int y = 0; y < 5; ++y) {
                        int i = y * 5 + x;
                        ItemStack in = this.items.getStackInSlot(2 + i);
                        if (in.isEmpty()) continue;
                        int index = y * ((XpRecipe)recipe.value()).getWidth() + x;
                        in.setCount(in.getCount() - ((Ingredient)((XpRecipe)recipe.value()).getIngredients().get(index)).getItems()[0].getCount());
                        this.items.setStackInSlot(2 + i, in);
                    }
                }
            }
        });
    }

    private void addBonusEffects(ITrinketItem trinket, ItemStack stack) {
        float targetQuality = 100.0f * (float)(this.getExperience() + (Integer)Config.EXPERIENCE_OFFSET.get()) / (float)((Integer)Config.MAXEXPERIENCE.get() + (Integer)Config.EXPERIENCE_OFFSET.get());
        if (TrinketItem.addBonusEffects(this.level, trinket, stack, targetQuality)) {
            this.setData(XpCrafterModule.EXPERIENCE_CRAFTER_DATA, ExperienceCrafterData.DEFAULT);
            this.setChanged();
        }
    }

    private void onUpdate(int slot, ItemStack stack) {
        if (slot >= 2) {
            this.updatePreview();
        }
    }

    private void updatePreview() {
        Optional<RecipeHolder<XpRecipe>> result = this.findRecipe();
        ItemStack output = result.map(p -> ((XpRecipe)p.value()).getResultItem()).orElse(ItemStack.EMPTY);
        this.items.setStackInSlot(1, output);
        this.setChanged();
    }

    @NotNull
    private Optional<RecipeHolder<XpRecipe>> findRecipe() {
        for (int i = 2; i < 27; ++i) {
            this.inv.setItem(i - 2, this.items.getStackInSlot(i));
        }
        CraftingInput input = CraftingInput.of((int)5, (int)5, (List)this.inv.getItems());
        return this.level.getRecipeManager().getRecipeFor(XpCrafterModule.XP_RECIPE_TYPE.get(), (RecipeInput)input, this.level);
    }

    private void fillExperience(ServerPlayer player) {
        int level = player.experienceLevel;
        int maxXp = (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel() + (float)ExperienceCrafterBE.getTotalXpForLevel(level));
        int toExtract = Math.min(maxXp, (Integer)Config.MAXEXPERIENCE.get());
        player.giveExperiencePoints(-toExtract);
        this.setExperience(this.getExperience() + toExtract);
    }

    public static int getTotalXpForLevel(int level) {
        if (level < 17) {
            return level * level + 6 * level;
        }
        if (level < 32) {
            return Mth.floor((double)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0));
        }
        return Mth.floor((double)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
    }

    public int getExperience() {
        ExperienceCrafterData data = (ExperienceCrafterData)this.getData(XpCrafterModule.EXPERIENCE_CRAFTER_DATA);
        return data.experience();
    }

    public void setExperience(int exp) {
        this.setData(XpCrafterModule.EXPERIENCE_CRAFTER_DATA, new ExperienceCrafterData(exp));
    }

    public ItemStack getPreviewOutput() {
        return this.items.getStackInSlot(1);
    }
}

