/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.xpcrafter.recipe;

import com.mcjty.fancytrinkets.modules.xpcrafter.XpCrafterModule;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.BaseShapedRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class XpRecipe
extends BaseShapedRecipe {
    private final ResourceLocation id;
    private final ItemStack result;
    public static final int RECIPE_DIMENSION = 5;

    public XpRecipe(String group, ResourceLocation id, ShapedRecipePattern pattern, ItemStack result) {
        super(group, CraftingBookCategory.MISC, pattern, result);
        this.id = id;
        this.result = result;
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        for (int i = 0; i < inv.width() * inv.height(); ++i) {
            if (((Ingredient)this.pattern.ingredients().get(i)).test(inv.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth == 5 && pHeight == 5;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return XpCrafterModule.XP_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return XpCrafterModule.XP_RECIPE_TYPE.get();
    }
}

