/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.modules.xpcrafter.recipe;

import com.mcjty.fancytrinkets.modules.xpcrafter.recipe.XpRecipe;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.lib.varia.Tools;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class XpRecipeBuilder
implements IRecipeBuilder<XpRecipeBuilder> {
    private final ItemStack result;
    private ShapedRecipeBuilder builder;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();

    public XpRecipeBuilder(ItemStack result) {
        this.result = result;
        this.builder = new ShapedRecipeBuilder(RecipeCategory.MISC, this.result);
    }

    public static XpRecipeBuilder shapedRecipe(ItemStack result) {
        return new XpRecipeBuilder(result);
    }

    public XpRecipeBuilder define(Character symbol, TagKey<Item> tagKey) {
        return this.define(symbol, Ingredient.of(tagKey));
    }

    public XpRecipeBuilder define(Character symbol, ItemLike itemLike) {
        return this.define(symbol, Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
    }

    public XpRecipeBuilder define(Character symbol, Ingredient ingredient) {
        this.builder = this.builder.define(symbol, ingredient);
        return this;
    }

    public XpRecipeBuilder patternLine(String patternIn) {
        this.builder = this.builder.pattern(patternIn);
        return this;
    }

    public XpRecipeBuilder unlockedBy(String name, Criterion<? extends CriterionTriggerInstance> criterionIn) {
        this.builder = this.builder.unlockedBy(name, criterionIn);
        return this;
    }

    public XpRecipeBuilder setGroup(String groupIn) {
        return this;
    }

    public void build(RecipeOutput consumer) {
        this.build(consumer, Tools.getId((Item)this.result.getItem()));
    }

    public void build(RecipeOutput consumer, String save) {
        this.build(consumer, ResourceLocation.parse((String)save));
    }

    public void build(final RecipeOutput consumer, final ResourceLocation id) {
        this.builder.save(new RecipeOutput(){

            public Advancement.Builder advancement() {
                return XpRecipeBuilder.this.advancementBuilder;
            }

            public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
                consumer.accept(id, (Recipe)new XpRecipe(recipe.getGroup(), id, ((ShapedRecipe)recipe).pattern, recipe.getResultItem(null)), advancementHolder, iConditions);
            }
        });
    }
}

