/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.playerdata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public record PlayerEffectData(Set<String> toggles, Map<String, Float> damageReduction) {
    public static final PlayerEffectData DEFAULT = new PlayerEffectData(Collections.emptySet(), Collections.emptyMap());
    private static final Codec<Set<String>> TOGGLE_CODEC = Codec.list((Codec)Codec.STRING).xmap(HashSet::new, ArrayList::new);
    private static final Codec<Map<String, Float>> DAMAGE_REDUCTION_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).xmap(HashMap::new, map -> map);
    public static final Codec<PlayerEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TOGGLE_CODEC.optionalFieldOf("toggles", Set.of()).forGetter(playerEffects -> playerEffects.toggles), (App)DAMAGE_REDUCTION_CODEC.optionalFieldOf("damageReduction", Map.of()).forGetter(playerEffects -> playerEffects.damageReduction)).apply((Applicative)instance, PlayerEffectData::new));

    public PlayerEffectData toggle(String toggle) {
        HashSet<String> newToggles = new HashSet<String>(this.toggles);
        if (newToggles.contains(toggle)) {
            newToggles.remove(toggle);
        } else {
            newToggles.add(toggle);
        }
        return new PlayerEffectData(newToggles, this.damageReduction);
    }

    public boolean isToggleOn(String toggle) {
        return this.toggles.contains(toggle);
    }

    public PlayerEffectData registerDamageReduction(String dmgId, float factor) {
        HashMap<String, Float> newDamageReduction = new HashMap<String, Float>(this.damageReduction);
        newDamageReduction.put(dmgId, Float.valueOf(factor));
        return new PlayerEffectData(this.toggles, newDamageReduction);
    }

    public PlayerEffectData unregisterDamageReduction(String dmgId) {
        HashMap<String, Float> newDamageReduction = new HashMap<String, Float>(this.damageReduction);
        newDamageReduction.remove(dmgId);
        return new PlayerEffectData(this.toggles, newDamageReduction);
    }

    public float getDamageReduction(String dmgId) {
        return this.damageReduction.getOrDefault(dmgId, Float.valueOf(1.0f)).floatValue();
    }
}

