/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.playerdata;

import com.mcjty.fancytrinkets.modules.effects.IEffect;
import com.mcjty.fancytrinkets.playerdata.PacketSyncPlayerEffects;
import com.mcjty.fancytrinkets.playerdata.PlayerEffectData;
import com.mcjty.fancytrinkets.setup.Messages;
import com.mcjty.fancytrinkets.setup.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mcjty.lib.varia.Counter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerEffects {
    private static final Map<UUID, PlayerEffects> PLAYER_EFFECTS_MAP = new HashMap<UUID, PlayerEffects>();
    private final Map<String, EffectHolder> effectMap = new HashMap<String, EffectHolder>();

    public static void cleanup() {
        PLAYER_EFFECTS_MAP.clear();
    }

    public void tick(ServerPlayer player) {
        long time = player.level().getGameTime();
        Counter collectedEffects = new Counter();
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry<String, EffectHolder> entry : this.effectMap.entrySet()) {
            EffectHolder holder = entry.getValue();
            if (holder.endTime >= time) {
                collectedEffects.increment((Object)holder.effect);
                continue;
            }
            toDelete.add(entry.getKey());
        }
        for (Map.Entry<String, EffectHolder> entry : collectedEffects.entrySet()) {
            ((IEffect)((Object)entry.getKey())).perform(player, (Integer)((Object)entry.getValue()));
        }
        for (String index : toDelete) {
            this.effectMap.remove(index);
        }
    }

    public boolean toggle(ServerPlayer player, String toggle) {
        PlayerEffectData data = (PlayerEffectData)player.getData(Registration.PLAYER_EFFECTS);
        data = data.toggle(toggle);
        player.setData(Registration.PLAYER_EFFECTS, (Object)data);
        Messages.sendToPlayer(PacketSyncPlayerEffects.create(data), (Player)player);
        return data.isToggleOn(toggle);
    }

    public boolean isToggleOn(ServerPlayer player, String toggle) {
        PlayerEffectData data = (PlayerEffectData)player.getData(Registration.PLAYER_EFFECTS);
        return data.isToggleOn(toggle);
    }

    public void registerEffect(String slotId, IEffect effect, long endTime) {
        this.effectMap.put(slotId, new EffectHolder(effect, endTime));
    }

    public void unregisterEffect(String slotId) {
        this.effectMap.remove(slotId);
    }

    public void registerDamageReduction(ServerPlayer player, String dmgId, float factor) {
        PlayerEffectData data = (PlayerEffectData)player.getData(Registration.PLAYER_EFFECTS);
        data = data.registerDamageReduction(dmgId, factor);
        player.setData(Registration.PLAYER_EFFECTS, (Object)data);
    }

    public void unregisterDamageReduction(ServerPlayer player, String dmgId) {
        PlayerEffectData data = (PlayerEffectData)player.getData(Registration.PLAYER_EFFECTS);
        data = data.unregisterDamageReduction(dmgId);
        player.setData(Registration.PLAYER_EFFECTS, (Object)data);
    }

    public float getDamageReduction(ServerPlayer player, String dmgId) {
        PlayerEffectData data = (PlayerEffectData)player.getData(Registration.PLAYER_EFFECTS);
        return data.getDamageReduction(dmgId);
    }

    public void copyFrom(PlayerEffects source) {
        this.effectMap.clear();
        this.effectMap.putAll(source.effectMap);
    }

    public static PlayerEffects getPlayerEffects(Player player) {
        return PLAYER_EFFECTS_MAP.computeIfAbsent(player.getUUID(), uuid -> new PlayerEffects());
    }

    public static void setPlayerEffects(Player player, PlayerEffects effects) {
        PLAYER_EFFECTS_MAP.put(player.getUUID(), effects);
    }

    public record EffectHolder(IEffect effect, long endTime) {
    }
}

