/*
 * Decompiled with CFR 0.152.
 */
package com.mcjty.fancytrinkets.setup;

import com.mcjty.fancytrinkets.playerdata.PlayerEffects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PlayerEffects playerEffects = PlayerEffects.getPlayerEffects((Player)player);
            String msgId = event.getSource().getMsgId();
            float reduction = playerEffects.getDamageReduction(player, msgId);
            float damage = event.getNewDamage() * reduction;
            event.setNewDamage(damage);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEffects effects = PlayerEffects.getPlayerEffects((Player)serverPlayer);
            effects.tick(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerAboutToStartEvent event) {
        PlayerEffects.cleanup();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        PlayerEffects.cleanup();
    }
}

