/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.energy;

import net.danygames2014.nyalib.energy.EnergyHandler;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public interface EnergyConsumer
extends EnergyHandler {
    public int getMaxInputVoltage(@Nullable Direction var1);

    public int getMaxEnergyInput(@Nullable Direction var1);

    public boolean canReceiveEnergy(@Nullable Direction var1);

    default public int receiveEnergy(@Nullable Direction direction, int voltage, int energy) {
        if (!this.canReceiveEnergy(direction)) {
            return 0;
        }
        if (energy <= 0) {
            return 0;
        }
        if (this.getRemainingCapacity() <= 0) {
            return 0;
        }
        if (voltage > this.getMaxInputVoltage(direction)) {
            this.onOvervoltage(direction, voltage);
            return 0;
        }
        return this.addEnergy(Math.min(energy, this.getMaxEnergyInput(direction)));
    }

    public void onOvervoltage(@Nullable Direction var1, double var2);
}

