/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.energy;

public interface EnergyStorage {
    public int getEnergyStored();

    public int getEnergyCapacity();

    default public int getRemainingCapacity() {
        return this.getEnergyCapacity() - this.getEnergyStored();
    }

    public int setEnergy(int var1);

    default public int changeEnergy(int difference) {
        int prevEnergy = this.getEnergyStored();
        int desiredEnergy = prevEnergy + difference;
        if (desiredEnergy > this.getEnergyCapacity()) {
            this.setEnergy(this.getEnergyCapacity());
        } else if (desiredEnergy < 0) {
            this.setEnergy(0);
        } else {
            this.setEnergy(desiredEnergy);
        }
        int newEnergy = this.getEnergyStored();
        return newEnergy - prevEnergy;
    }

    default public int addEnergy(int amount) {
        return this.changeEnergy(amount);
    }

    default public int removeEnergy(int amount) {
        return Math.abs(this.changeEnergy(-amount));
    }
}

