/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidCapable;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public interface FluidHandler
extends FluidCapable {
    public boolean canExtractFluid(@Nullable Direction var1);

    public FluidStack extractFluid(int var1, int var2, @Nullable Direction var3);

    default public FluidStack extractFluid(Fluid fluid, int amount, @Nullable Direction direction) {
        FluidStack currentStack = null;
        int remaining = amount;
        for (int i = 0; i < this.getFluidSlots(direction) && remaining > 0; ++i) {
            FluidStack extractedStack;
            if (currentStack != null) {
                if (!this.getFluidInSlot(i, direction).isFluidEqual(currentStack)) continue;
                extractedStack = this.extractFluid(i, remaining, direction);
                remaining -= extractedStack.amount;
                currentStack.amount += extractedStack.amount;
                continue;
            }
            extractedStack = this.extractFluid(i, remaining, direction);
            remaining -= extractedStack.amount;
            currentStack = extractedStack;
        }
        return currentStack;
    }

    public boolean canInsertFluid(@Nullable Direction var1);

    public FluidStack insertFluid(FluidStack var1, int var2, @Nullable Direction var3);

    public FluidStack insertFluid(FluidStack var1, @Nullable Direction var2);

    public FluidStack getFluidInSlot(int var1, @Nullable Direction var2);

    public int getFluidSlots(@Nullable Direction var1);

    public int getFluidCapacity(int var1, @Nullable Direction var2);

    public FluidStack[] getFluids(@Nullable Direction var1);
}

