/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.world.structure;

import net.danygames2014.nyalib.world.structure.CollisionType;
import net.danygames2014.nyalib.world.structure.Rotation;
import net.danygames2014.nyalib.world.structure.Structure;
import net.danygames2014.nyalib.world.structure.StructureBlockEntry;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;

public class TreeStructure
extends Structure {
    public BlockState trunkBlockState;
    public CollisionType trunkCollisionType;

    public TreeStructure(class_18 world, BlockState trunkBlockState, CollisionType trunkCollisionType) {
        super(world);
        this.trunkBlockState = trunkBlockState;
        this.trunkCollisionType = trunkCollisionType;
    }

    public boolean checkCollision(class_18 world, int x, int y, int z, int trunkHeight) {
        for (int i = 0; i < trunkHeight; ++i) {
            if (this.isReplaceable(world, x, y + i, z) || this.trunkCollisionType != CollisionType.DONT_GENERATE) continue;
            return false;
        }
        return super.checkCollision(world, x, y + trunkHeight, z);
    }

    public boolean generate(class_18 world, int x, int y, int z, int trunkHeight) {
        if (!this.checkCollision(world, x, y, z, trunkHeight)) {
            return false;
        }
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeState(world, x, y + i, z, this.trunkBlockState, this.trunkCollisionType);
        }
        for (StructureBlockEntry block : this.blocks) {
            this.placeBlock(world, x, y + trunkHeight, z, block, Rotation.NONE);
        }
        return true;
    }
}

