/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.yirmiri.dungeonsdelight.datagen.DDBlockLootGen;
import net.yirmiri.dungeonsdelight.datagen.DDBlockTagGen;
import net.yirmiri.dungeonsdelight.datagen.DDBlockstateGen;
import net.yirmiri.dungeonsdelight.datagen.DDEnchantmentTagGen;
import net.yirmiri.dungeonsdelight.datagen.DDEnchantments;
import net.yirmiri.dungeonsdelight.datagen.DDItemModelGen;
import net.yirmiri.dungeonsdelight.datagen.DDItemTagGen;
import net.yirmiri.dungeonsdelight.datagen.DDLangGen;
import net.yirmiri.dungeonsdelight.datagen.DDRecipeGen;

@EventBusSubscriber(modid="dungeonsdelight", bus=EventBusSubscriber.Bus.MOD)
public class DDDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RegistrySetBuilder registrySetBuilder = new RegistrySetBuilder().add(Registries.ENCHANTMENT, DDEnchantments::bootstrap);
        DatapackBuiltinEntriesProvider datapackProvider = new DatapackBuiltinEntriesProvider(output, provider, registrySetBuilder, Set.of("dungeonsdelight"));
        CompletableFuture builtinLookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(true, (DataProvider)new DDEnchantmentTagGen(output, builtinLookupProvider, helper));
        DDBlockTagGen blockTags = new DDBlockTagGen(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new DDItemTagGen(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(true, (DataProvider)new DDBlockstateGen(output, helper));
        generator.addProvider(true, (DataProvider)new DDItemModelGen(output, helper));
        generator.addProvider(true, (DataProvider)new DDLangGen(output));
        generator.addProvider(true, (DataProvider)new DDRecipeGen(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(DDBlockLootGen::new, LootContextParamSets.BLOCK)), provider));
    }
}

