/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;

public class EmbeddedEggsBlock
extends Block {
    public static IntegerProperty SCULKING = IntegerProperty.create((String)"sculking", (int)0, (int)4);

    public EmbeddedEggsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)SCULKING, (Comparable)Integer.valueOf(0)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SCULKING});
        super.createBlockStateDefinition(builder);
    }

    public int getMaxCompostingStage() {
        return 4;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            float chance = 0.0f;
            int maxLight = 0;
            for (BlockPos neighborPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                int light;
                BlockState neighborState = level.getBlockState(neighborPos);
                if (neighborState.is(DDTags.BlockT.SCULKING_ACTIVATORS) || neighborState.is(DDTags.BlockT.MONSTER_HEAT_SOURCES)) {
                    chance += 0.02f;
                }
                if ((light = level.getBrightness(LightLayer.SKY, neighborPos.above())) <= maxLight || !level.isNight()) continue;
                maxLight = light;
            }
            chance += maxLight > 7 ? 0.1f : 0.05f;
            if (level.getRandom().nextFloat() <= chance) {
                if (((Integer)state.getValue((Property)SCULKING)).intValue() == this.getMaxCompostingStage()) {
                    level.setBlock(pos, DDBlocks.HEAP_OF_ANCIENT_EGGS.get().defaultBlockState(), 3);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)SCULKING, (Comparable)Integer.valueOf((Integer)state.getValue((Property)SCULKING) + 1)), 3);
                }
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxCompostingStage() + 1 - (Integer)blockState.getValue((Property)SCULKING);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + (double)random.nextFloat(), (double)pos.getY() + 1.1, (double)pos.getZ() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }
}

